/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContextCrudService;
import io.gravitee.apim.core.portal_page.domain_service.PageExistsSpecification;
import io.gravitee.apim.core.portal_page.model.PageId;
import io.gravitee.apim.core.portal_page.model.PortalPageView;
import io.gravitee.apim.core.portal_page.model.PortalPageWithViewDetails;
import io.gravitee.apim.core.portal_page.query_service.PortalPageQueryService;
import java.util.Objects;
import lombok.Generated;

@UseCase
public class UpdatePortalPageViewPublicationStatusUseCase {
    private final PortalPageContextCrudService portalPageContextCrudService;
    private final PortalPageQueryService portalPageQueryService;

    public Output execute(Input input) {
        PortalPageView portalPageView = this.portalPageContextCrudService.findByPageId(input.pageId());
        PageExistsSpecification<PortalPageView> pageExistsSpec = new PageExistsSpecification<PortalPageView>(Objects::nonNull);
        pageExistsSpec.throwIfNotSatisfied(portalPageView);
        PortalPageView toUpdate = input.published() ? portalPageView.publish() : portalPageView.unpublish();
        PortalPageView updatedDetails = this.portalPageContextCrudService.update(input.pageId(), toUpdate);
        return new Output(this.portalPageQueryService.loadContentFor(input.pageId(), updatedDetails));
    }

    @Generated
    public UpdatePortalPageViewPublicationStatusUseCase(PortalPageContextCrudService portalPageContextCrudService, PortalPageQueryService portalPageQueryService) {
        this.portalPageContextCrudService = portalPageContextCrudService;
        this.portalPageQueryService = portalPageQueryService;
    }

    public record Input(PageId pageId, boolean published) {
    }

    public record Output(PortalPageWithViewDetails portalPage) {
    }
}

