/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.cluster.model.Cluster;
import io.gravitee.apim.core.cluster.model.ClusterSearchCriteria;
import io.gravitee.apim.core.cluster.query_service.ClusterQueryService;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.core.permission.domain_service.PermissionDomainService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class SearchClusterUseCase {
    private final ClusterQueryService clusterQueryService;
    private final MembershipQueryService membershipQueryService;
    private final PermissionDomainService permissionDomainService;

    public Output execute(Input input) {
        ClusterSearchCriteria.ClusterSearchCriteriaBuilder criteriaBuilder = ClusterSearchCriteria.builder().environmentId(input.environmentId);
        if (!input.isAdmin) {
            List<String> clustersIdsUserCanRead = this.membershipQueryService.findClustersIdsThatUserBelongsTo(input.userId);
            if (clustersIdsUserCanRead.isEmpty()) {
                return new Output((Page<Cluster>)new Page(Collections.emptyList(), 1, 0, 0L));
            }
            criteriaBuilder.ids(clustersIdsUserCanRead);
        }
        if (input.query != null && !input.query.isBlank()) {
            criteriaBuilder.query(input.query);
        }
        Pageable pageable = Optional.ofNullable(input.pageable).orElse((Pageable)new PageableImpl(1, 10));
        return new Output((Page<Cluster>)this.clusterQueryService.search(criteriaBuilder.build(), pageable, this.generateSortable(input.sortBy)).map(cluster -> {
            this.setClusterConfigurationIfPermitted(input, (Cluster)cluster);
            return cluster;
        }));
    }

    private void setClusterConfigurationIfPermitted(Input input, Cluster cluster) {
        if (!this.permissionDomainService.hasPermission(cluster.getOrganizationId(), input.userId(), RolePermission.CLUSTER_CONFIGURATION, cluster.getId(), RolePermissionAction.READ)) {
            cluster.setConfiguration(null);
        }
    }

    private Optional<Sortable> generateSortable(String sortBy) {
        if (sortBy == null) {
            return Optional.empty();
        }
        boolean isAscending = !sortBy.startsWith("-");
        String field = isAscending ? sortBy : sortBy.substring(1);
        return Optional.of(new SortableImpl(field, isAscending));
    }

    @Generated
    public SearchClusterUseCase(ClusterQueryService clusterQueryService, MembershipQueryService membershipQueryService, PermissionDomainService permissionDomainService) {
        this.clusterQueryService = clusterQueryService;
        this.membershipQueryService = membershipQueryService;
        this.permissionDomainService = permissionDomainService;
    }

    public record Input(String environmentId, String query, Pageable pageable, String sortBy, boolean isAdmin, String userId) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String environmentId;
            @Generated
            private String query;
            @Generated
            private Pageable pageable;
            @Generated
            private String sortBy;
            @Generated
            private boolean isAdmin;
            @Generated
            private String userId;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder query(String query) {
                this.query = query;
                return this;
            }

            @Generated
            public InputBuilder pageable(Pageable pageable) {
                this.pageable = pageable;
                return this;
            }

            @Generated
            public InputBuilder sortBy(String sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            @Generated
            public InputBuilder isAdmin(boolean isAdmin) {
                this.isAdmin = isAdmin;
                return this;
            }

            @Generated
            public InputBuilder userId(String userId) {
                this.userId = userId;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.environmentId, this.query, this.pageable, this.sortBy, this.isAdmin, this.userId);
            }

            @Generated
            public String toString() {
                return "SearchClusterUseCase.Input.InputBuilder(environmentId=" + this.environmentId + ", query=" + this.query + ", pageable=" + String.valueOf(this.pageable) + ", sortBy=" + this.sortBy + ", isAdmin=" + this.isAdmin + ", userId=" + this.userId + ")";
            }
        }
    }

    public record Output(Page<Cluster> pageResult) {
    }
}

