/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.NotificationCRDDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiCRDDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.ApiCRDStatus;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.api.use_case.UpdateNativeApiUseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.CreateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageParentException;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.factory.PageModelFactory;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.exception.AbstractDomainException;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.member.domain_service.CRDMembersDomainService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.DeletePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.ReorderPlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.nativeapi.NativePlan;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class ImportApiCRDUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportApiCRDUseCase.class);
    private final ApiQueryService apiQueryService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ValidateApiDomainService validateApiDomainService;
    private final CreateApiDomainService createApiDomainService;
    private final CreatePlanDomainService createPlanDomainService;
    private final ApiStateDomainService apiStateDomainService;
    private final UpdateApiDomainService updateApiDomainService;
    private final UpdateNativeApiUseCase updateNativeApiUseCase;
    private final ApiCrudService apiCrudService;
    private final PlanQueryService planQueryService;
    private final PageQueryService pageQueryService;
    private final PageCrudService pageCrudService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final DeletePlanDomainService deletePlanDomainService;
    private final SubscriptionQueryService subscriptionQueryService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;
    private final ReorderPlanDomainService reorderPlanDomainService;
    private final CRDMembersDomainService membersDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final CreateApiDocumentationDomainService createApiDocumentationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final ValidateApiCRDDomainService validateCRDDomainService;
    private final NotificationCRDDomainService notificationCRDService;

    public ImportApiCRDUseCase(ApiCrudService apiCrudService, ApiQueryService apiQueryService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ValidateApiDomainService validateApiDomainService, CreateApiDomainService createApiDomainService, CreatePlanDomainService createPlanDomainService, ApiStateDomainService apiStateDomainService, UpdateApiDomainService updateApiDomainService, UpdateNativeApiUseCase updateNativeApiUseCase, PlanQueryService planQueryService, UpdatePlanDomainService updatePlanDomainService, DeletePlanDomainService deletePlanDomainService, SubscriptionQueryService subscriptionQueryService, CloseSubscriptionDomainService closeSubscriptionDomainService, ReorderPlanDomainService reorderPlanDomainService, CRDMembersDomainService membersDomainService, ApiMetadataDomainService apiMetadataDomainService, PageQueryService pageQueryService, PageCrudService pageCrudService, CreateApiDocumentationDomainService createApiDocumentationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService, ValidateApiCRDDomainService validateCRDDomainService, NotificationCRDDomainService notificationCRDService) {
        this.apiCrudService = apiCrudService;
        this.apiQueryService = apiQueryService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.validateApiDomainService = validateApiDomainService;
        this.createApiDomainService = createApiDomainService;
        this.createPlanDomainService = createPlanDomainService;
        this.apiStateDomainService = apiStateDomainService;
        this.updateApiDomainService = updateApiDomainService;
        this.updateNativeApiUseCase = updateNativeApiUseCase;
        this.planQueryService = planQueryService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.deletePlanDomainService = deletePlanDomainService;
        this.subscriptionQueryService = subscriptionQueryService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
        this.reorderPlanDomainService = reorderPlanDomainService;
        this.membersDomainService = membersDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.pageQueryService = pageQueryService;
        this.pageCrudService = pageCrudService;
        this.createApiDocumentationDomainService = createApiDocumentationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.validateCRDDomainService = validateCRDDomainService;
        this.notificationCRDService = notificationCRDService;
    }

    public Output execute(Input input) {
        Validator.Result<Input> validationResult = this.validateCRDDomainService.validateAndSanitize(new ValidateApiCRDDomainService.Input(input.auditInfo(), input.spec())).map(sanitized -> new Input(sanitized.auditInfo(), sanitized.spec()));
        validationResult.severe().ifPresent(errors -> {
            throw new ValidationDomainException(String.format("Unable to import because of errors [%s]", String.join((CharSequence)",", errors.stream().map(Validator.Error::getMessage).toList())));
        });
        List warnings = validationResult.warning().orElseGet(List::of);
        Input sanitizedInput = validationResult.value().orElseThrow(() -> new ValidationDomainException("Unable to sanitize CRD spec"));
        Optional<Api> api = this.apiQueryService.findByEnvironmentIdAndCrossId(sanitizedInput.auditInfo.environmentId(), sanitizedInput.spec.getCrossId());
        ApiCRDStatus status = api.map(exiting -> this.update(sanitizedInput, (Api)exiting)).orElseGet(() -> this.create(sanitizedInput));
        status.setErrors(ApiCRDStatus.Errors.fromErrorList(warnings));
        return new Output(status);
    }

    private ApiCRDStatus create(Input input) {
        try {
            String environmentId = input.auditInfo.environmentId();
            String organizationId = input.auditInfo.organizationId();
            PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(organizationId, environmentId, input.auditInfo.actor().userId());
            ApiWithFlows createdApi = this.createApiDomainService.create(ApiModelFactory.fromCrd(input.spec, environmentId), primaryOwner, input.auditInfo, api -> this.validateApiDomainService.validateAndSanitizeForCreation((Api)api, primaryOwner, environmentId, organizationId), ApiIndexerDomainService.oneShotIndexation(input.auditInfo));
            Map<String, String> planNameIdMapping = input.spec.getPlans().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.createPlanDomainService.create(this.initPlanFromCRD((String)entry.getKey(), (PlanCRD)entry.getValue(), createdApi), ((PlanCRD)entry.getValue()).getFlows(), createdApi, input.auditInfo).getId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.membersDomainService.updateApiMembers(input.auditInfo, createdApi.getId(), input.spec().getMembers());
            this.createOrUpdatePages(input.spec.getPages(), createdApi.getId(), input.auditInfo);
            this.apiMetadataDomainService.importApiMetadata(createdApi.getId(), input.spec.getMetadata(), input.auditInfo);
            this.notificationCRDService.syncApiPortalNotifications(createdApi.getId(), input.auditInfo.actor().userId(), input.spec.getConsoleNotificationConfiguration());
            if (ImportApiCRDUseCase.shouldDeploy(input.spec())) {
                this.apiStateDomainService.start(createdApi, input.auditInfo);
            }
            return ApiCRDStatus.builder().id(createdApi.getId()).crossId(createdApi.getCrossId()).environmentId(environmentId).organizationId(organizationId).state(createdApi.getLifecycleState().name()).plans(planNameIdMapping).build();
        }
        catch (AbstractDomainException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private ApiCRDStatus update(Input input, Api existingApi) {
        try {
            Api updatedApi = existingApi.isNative() ? this.updateNativeApiUseCase.execute(new UpdateNativeApiUseCase.Input(ApiModelFactory.toUpdateNativeApi(input.spec), input.auditInfo)).updatedApi() : this.updateApiDomainService.update(existingApi.getId(), input.spec, input.auditInfo);
            Api api = this.apiCrudService.update((Api)((Api.ApiBuilder)((Api.ApiBuilder)updatedApi.toBuilder().originContext((OriginContext)new OriginContext.Kubernetes(OriginContext.Kubernetes.Mode.valueOf((String)input.spec().getDefinitionContext().getMode().toUpperCase()), input.spec().getDefinitionContext().getSyncFrom().toUpperCase()))).lifecycleState(Api.LifecycleState.valueOf(input.spec().getState()))).build());
            this.createOrUpdatePages(input.spec.getPages(), updatedApi.getId(), input.auditInfo);
            this.deleteRemovedPages(input.spec.getPages(), updatedApi.getId());
            Map<String, String> planKeyIdMapping = this.handlePlanUpdate(input, api);
            this.handleLifeCycle(input, existingApi, api);
            this.membersDomainService.updateApiMembers(input.auditInfo, updatedApi.getId(), input.spec().getMembers());
            this.apiMetadataDomainService.importApiMetadata(api.getId(), input.spec.getMetadata(), input.auditInfo);
            this.notificationCRDService.syncApiPortalNotifications(api.getId(), input.auditInfo.actor().userId(), input.spec.getConsoleNotificationConfiguration());
            return ApiCRDStatus.builder().id(api.getId()).crossId(api.getCrossId()).environmentId(api.getEnvironmentId()).organizationId(input.auditInfo.organizationId()).state(api.getLifecycleState().name()).plans(planKeyIdMapping).build();
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private void handleLifeCycle(Input input, Api existingApi, Api api) {
        if (ImportApiCRDUseCase.shouldDeploy(input.spec())) {
            this.apiStateDomainService.deploy(api, "Updated by GKO", input.auditInfo);
        }
        if (api.getLifecycleState() != existingApi.getLifecycleState()) {
            if (api.getLifecycleState() == Api.LifecycleState.STOPPED) {
                this.apiStateDomainService.stop(api, input.auditInfo);
            } else {
                this.apiStateDomainService.start(api, input.auditInfo);
            }
        }
    }

    private Map<String, String> handlePlanUpdate(Input input, Api api) {
        List<Plan> existingPlans = this.planQueryService.findAllByApiId(api.getId());
        Map<String, PlanStatus> existingPlanStatuses = existingPlans.stream().collect(Collectors.toMap(Plan::getId, Plan::getPlanStatus));
        HashMap<String, String> keyToIdMapping = new HashMap<String, String>();
        HashMap<String, List<? extends AbstractFlow>> updateFlows = new HashMap<String, List<? extends AbstractFlow>>();
        List<Plan> plansToUpdate = input.spec().getPlans().entrySet().stream().filter(e -> existingPlanStatuses.containsKey(((PlanCRD)e.getValue()).getId())).map(e -> {
            updateFlows.put(((PlanCRD)e.getValue()).getId(), ((PlanCRD)e.getValue()).getFlows());
            keyToIdMapping.put((String)e.getKey(), ((PlanCRD)e.getValue()).getId());
            return this.initPlanFromCRD((String)e.getKey(), (PlanCRD)e.getValue(), api);
        }).toList();
        this.updatePlanDomainService.bulkUpdate(plansToUpdate, existingPlanStatuses, updateFlows, api, input.auditInfo);
        input.spec().getPlans().entrySet().stream().filter(e -> !existingPlanStatuses.containsKey(((PlanCRD)e.getValue()).getId())).forEach(e -> {
            Plan plan = this.initPlanFromCRD((String)e.getKey(), (PlanCRD)e.getValue(), api);
            PlanWithFlows created = this.createPlanDomainService.create(plan, ((PlanCRD)e.getValue()).getFlows(), api, input.auditInfo);
            keyToIdMapping.put((String)e.getKey(), created.getId());
        });
        List<Plan> plansToDelete = existingPlans.stream().filter(plan -> input.spec.getPlans().values().stream().noneMatch(p -> p.getId().equals(plan.getId()))).toList();
        this.deletePlans(plansToDelete, api, input.auditInfo);
        return keyToIdMapping;
    }

    private void deletePlans(List<Plan> plansToDelete, Api api, AuditInfo auditInfo) {
        plansToDelete.forEach(plan -> {
            this.subscriptionQueryService.findActiveSubscriptionsByPlan(plan.getId()).forEach(subscription -> this.closeSubscriptionDomainService.closeSubscription(subscription.getId(), auditInfo));
            this.deletePlanDomainService.delete((Plan)plan, auditInfo);
        });
        this.reorderPlanDomainService.refreshOrderAfterDelete(api.getId());
    }

    private Plan initPlanFromCRD(String hrid, PlanCRD planCRD, Api api) {
        Object plan = ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(planCRD.getId())).hrid(hrid)).name(planCRD.getName())).description(planCRD.getDescription())).characteristics(planCRD.getCharacteristics())).definitionVersion(api.getDefinitionVersion())).crossId(planCRD.getCrossId())).excludedGroups(planCRD.getExcludedGroups())).generalConditions(planCRD.getGeneralConditions())).generalConditionsHrid(planCRD.getGeneralConditionsHrid())).order(planCRD.getOrder())).type(planCRD.getType())).validation(planCRD.getValidation())).apiType(api.getType())).apiId(api.getId())).build();
        if (ApiType.NATIVE.equals((Object)api.getType())) {
            ((Plan)plan).setPlanDefinitionNativeV4(((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)((NativePlan.NativePlanBuilder)NativePlan.builder().security(planCRD.getSecurity())).selectionRule(planCRD.getSelectionRule())).status(planCRD.getStatus())).tags(planCRD.getTags())).mode(planCRD.getMode())).name(planCRD.getName())).build());
        } else {
            ((Plan)plan).setPlanDefinitionHttpV4(((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)io.gravitee.definition.model.v4.plan.Plan.builder().security(planCRD.getSecurity())).selectionRule(planCRD.getSelectionRule())).status(planCRD.getStatus())).tags(planCRD.getTags())).mode(planCRD.getMode())).name(planCRD.getName())).build());
        }
        return plan;
    }

    private void deleteRemovedPages(Map<String, PageCRD> pages, String apiId) {
        Set existingPageIds = this.pageQueryService.searchByApiId(apiId).stream().map(Page::getId).collect(Collectors.toSet());
        if (pages != null && !pages.isEmpty()) {
            Set givenPageIds = pages.values().stream().map(PageCRD::getId).collect(Collectors.toSet());
            existingPageIds.removeIf(givenPageIds::contains);
        }
        try {
            for (String id : existingPageIds) {
                this.pageCrudService.delete(id);
            }
        }
        catch (RuntimeException e) {
            log.error("An error as occurred while trying to remove a page with kubernetes origin");
        }
    }

    private void createOrUpdatePages(Map<String, PageCRD> pageCRDs, String apiId, AuditInfo auditInfo) {
        if (pageCRDs == null || pageCRDs.isEmpty()) {
            return;
        }
        Date now = Date.from(TimeProvider.now().toInstant());
        List<Page> pages = pageCRDs.entrySet().stream().map(entry -> PageModelFactory.fromCRDSpec((String)entry.getKey(), (PageCRD)entry.getValue())).toList();
        pages.forEach(page -> {
            page.setReferenceId(apiId);
            page.setReferenceType(Page.ReferenceType.API);
            if (page.getParentId() != null) {
                this.validatePageParent(pages, page.getParentId());
            }
            this.pageCrudService.findById(page.getId()).ifPresentOrElse(oldPage -> this.updateApiDocumentationDomainService.updatePage(page.toBuilder().createdAt(oldPage.getCreatedAt()).updatedAt(now).build(), (Page)oldPage, auditInfo), () -> this.createApiDocumentationDomainService.createPage(page.toBuilder().createdAt(now).updatedAt(now).build(), auditInfo));
        });
    }

    private void validatePageParent(List<Page> pages, String parentId) {
        pages.stream().filter(page -> parentId.equals(page.getId())).findFirst().ifPresent(parent -> {
            if (!parent.isFolder() && !parent.isRoot()) {
                throw new InvalidPageParentException(parent.getId());
            }
        });
    }

    private static boolean shouldDeploy(ApiCRDSpec spec) {
        return spec.getDefinitionContext().isSyncFromManagement() && Api.LifecycleState.STARTED.name().equalsIgnoreCase(spec.getState()) && spec.getPlans().values().stream().anyMatch(plan -> plan.getStatus() == PlanStatus.PUBLISHED || plan.getStatus() == PlanStatus.DEPRECATED);
    }

    public record Input(AuditInfo auditInfo, ApiCRDSpec spec) {
    }

    public record Output(ApiCRDStatus status) {
    }
}

