/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.initializer;

import io.gravitee.rest.api.model.permissions.ClusterPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.IntegrationPermission;
import io.gravitee.rest.api.model.permissions.OrganizationPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.upgrade.initializer.OrganizationInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultOrganizationAdminRoleInitializer
extends OrganizationInitializer {
    private final RoleService roleService;

    @Autowired
    public DefaultOrganizationAdminRoleInitializer(RoleService roleService) {
        this.roleService = roleService;
    }

    @Override
    protected void initializeOrganization(ExecutionContext executionContext) {
        this.roleService.createOrUpdateSystemRole(executionContext, SystemRole.ADMIN, RoleScope.ORGANIZATION, (Permission[])OrganizationPermission.values(), executionContext.getOrganizationId());
        this.roleService.createOrUpdateSystemRole(executionContext, SystemRole.ADMIN, RoleScope.ENVIRONMENT, (Permission[])EnvironmentPermission.values(), executionContext.getOrganizationId());
        this.roleService.createOrUpdateSystemRole(executionContext, SystemRole.PRIMARY_OWNER, RoleScope.INTEGRATION, (Permission[])IntegrationPermission.values(), executionContext.getOrganizationId());
        this.roleService.createOrUpdateSystemRole(executionContext, SystemRole.PRIMARY_OWNER, RoleScope.CLUSTER, (Permission[])ClusterPermission.values(), executionContext.getOrganizationId());
    }

    public int getOrder() {
        return 130;
    }
}

