/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.sanitizer;

import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.UrlForbiddenException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UrlSanitizerUtils {
    public static void checkAllowed(String url, List<String> whitelist, boolean allowPrivate) {
        UrlSanitizerUtils.checkUrlForbiddenCharacters(url);
        UrlSanitizerUtils.checkUriSyntax(url);
        if (whitelist != null && !whitelist.isEmpty() ? whitelist.stream().noneMatch(whitelistUrl -> whitelistUrl.endsWith("/") ? url.startsWith((String)whitelistUrl) : url.equals(whitelistUrl) || url.startsWith(whitelistUrl + "/")) : !allowPrivate && UrlSanitizerUtils.isPrivate(url)) {
            throw new UrlForbiddenException();
        }
    }

    public static boolean isPrivate(String url) {
        try {
            InetAddress inetAddress = Inet6Address.getByName(new URL(url).getHost());
            return inetAddress.isSiteLocalAddress() || inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isMulticastAddress() || UrlSanitizerUtils.isPrivateOwasp(inetAddress.getHostAddress());
        }
        catch (Exception e) {
            throw new InvalidDataException("Url [" + url + "] is invalid");
        }
    }

    public static void checkUriSyntax(String url) {
        try {
            new URI(url);
        }
        catch (Exception e) {
            throw new UrlForbiddenException();
        }
    }

    public static void checkUrlForbiddenCharacters(String url) {
        String urlEncodedCarriageReturn = "%0D";
        String urlEncodedLineFeed = "%0A";
        if (url.contains(urlEncodedCarriageReturn) || url.contains(urlEncodedLineFeed)) {
            throw new UrlForbiddenException();
        }
    }

    private static boolean isPrivateOwasp(String ipAddress) {
        ArrayList<String> ipPrefixes = new ArrayList<String>();
        ipPrefixes.add("127.");
        ipPrefixes.add("0.");
        ipPrefixes.add("10.");
        ipPrefixes.add("172.16.");
        ipPrefixes.add("172.17.");
        ipPrefixes.add("172.18.");
        ipPrefixes.add("172.19.");
        ipPrefixes.add("172.20.");
        ipPrefixes.add("172.21.");
        ipPrefixes.add("172.22.");
        ipPrefixes.add("172.23.");
        ipPrefixes.add("172.24.");
        ipPrefixes.add("172.25.");
        ipPrefixes.add("172.26.");
        ipPrefixes.add("172.27.");
        ipPrefixes.add("172.28.");
        ipPrefixes.add("172.29.");
        ipPrefixes.add("172.30.");
        ipPrefixes.add("172.31.");
        ipPrefixes.add("192.168.");
        ipPrefixes.add("169.254.");
        ipPrefixes.add("fc");
        ipPrefixes.add("fd");
        ipPrefixes.add("fe");
        ipPrefixes.add("ff");
        ipPrefixes.add("::1");
        ipPrefixes.add("0:0:0:0:0:0:0:0");
        String ipToVerify = ipAddress.toLowerCase();
        for (String prefix : ipPrefixes) {
            if (!ipToVerify.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

