/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.license;

import io.gravitee.apim.core.license.crud_service.LicenseCrudService;
import io.gravitee.apim.core.license.exception.LicenseNotFound;
import io.gravitee.apim.core.license.model.License;
import io.gravitee.apim.infra.adapter.LicenseAdapter;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.LicenseRepository;
import io.gravitee.repository.management.model.License;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class LicenseCrudServiceImpl
implements LicenseCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseCrudServiceImpl.class);
    private final LicenseRepository licenseRepository;

    public LicenseCrudServiceImpl(@Lazy LicenseRepository licenseRepository) {
        this.licenseRepository = licenseRepository;
    }

    @Override
    public Optional<License> getOrganizationLicense(String organizationId) {
        try {
            log.debug("Find license by organization id: {}", (Object)organizationId);
            return this.licenseRepository.findById(organizationId, License.ReferenceType.ORGANIZATION).map(LicenseAdapter.INSTANCE::toModel);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    @Override
    public License createOrganizationLicense(String organizationId, String license) {
        try {
            log.debug("Create license for organization id: {}", (Object)organizationId);
            ZonedDateTime currentTime = TimeProvider.now();
            License organizationLicense = License.builder().referenceType(License.ReferenceType.ORGANIZATION).referenceId(organizationId).license(license).createdAt(currentTime).updatedAt(currentTime).build();
            return LicenseAdapter.INSTANCE.toModel(this.licenseRepository.create(LicenseAdapter.INSTANCE.toRepository(organizationLicense)));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    @Override
    public License updateOrganizationLicense(String organizationId, String license) {
        try {
            log.debug("Update license for organization id: {}", (Object)organizationId);
            Optional organizationLicense = this.licenseRepository.findById(organizationId, License.ReferenceType.ORGANIZATION);
            if (organizationLicense.isPresent()) {
                return LicenseAdapter.INSTANCE.toModel(this.licenseRepository.update(((io.gravitee.repository.management.model.License)organizationLicense.get()).toBuilder().license(license).updatedAt(Date.from(TimeProvider.instantNow())).build()));
            }
            throw new LicenseNotFound(License.ReferenceType.ORGANIZATION.name(), organizationId);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }
}

