/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.scoring.model.ScoringFunction;
import io.gravitee.apim.infra.adapter.ScoringFunctionAdapter;
import io.gravitee.repository.management.model.ScoringFunction;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class ScoringFunctionAdapterImpl
implements ScoringFunctionAdapter {
    @Override
    public ScoringFunction toEntity(io.gravitee.repository.management.model.ScoringFunction source) {
        if (source == null) {
            return null;
        }
        ScoringFunction.ScoringFunctionBuilder scoringFunction = ScoringFunction.builder();
        scoringFunction.id(source.getId());
        scoringFunction.name(source.getName());
        scoringFunction.referenceId(source.getReferenceId());
        if (source.getReferenceType() != null) {
            scoringFunction.referenceType(Enum.valueOf(ScoringFunction.ReferenceType.class, source.getReferenceType()));
        }
        scoringFunction.payload(source.getPayload());
        if (source.getCreatedAt() != null) {
            scoringFunction.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return scoringFunction.build();
    }

    @Override
    public io.gravitee.repository.management.model.ScoringFunction toRepository(ScoringFunction source) {
        if (source == null) {
            return null;
        }
        ScoringFunction.ScoringFunctionBuilder scoringFunction = io.gravitee.repository.management.model.ScoringFunction.builder();
        scoringFunction.id(source.id());
        scoringFunction.name(source.name());
        scoringFunction.referenceId(source.referenceId());
        if (source.referenceType() != null) {
            scoringFunction.referenceType(source.referenceType().name());
        }
        if (source.createdAt() != null) {
            scoringFunction.createdAt(Date.from(source.createdAt().toInstant()));
        }
        scoringFunction.payload(source.payload());
        return scoringFunction.build();
    }
}

