/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.exception;

import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class FlowSelectorsInvalidException
extends AbstractManagementException {
    private final String name;
    private final ApiType apiType;
    private final Set<String> invalidSelectors;

    public FlowSelectorsInvalidException(String name, ApiType apiType, Set<String> invalidSelectors) {
        this.name = name;
        this.apiType = apiType;
        this.invalidSelectors = invalidSelectors;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "The flow [" + this.name + "] contains selectors " + String.valueOf(this.invalidSelectors) + " that couldn't apply to api type [" + this.apiType.getLabel() + "].";
    }

    @Override
    public String getTechnicalCode() {
        return "flow.selectors.type.invalid";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("flow.selectors.type.invalid", this.invalidSelectors.toString());
    }
}

