/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.organization.OrganizationCommand;
import io.gravitee.cockpit.api.command.v1.organization.OrganizationCommandPayload;
import io.gravitee.cockpit.api.command.v1.organization.OrganizationReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.exceptions.OrganizationNotFoundException;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrganizationCommandHandler
implements CommandHandler<OrganizationCommand, OrganizationReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationCommandHandler.class);
    private final OrganizationService organizationService;
    private final AccessPointCrudService accessPointService;
    private final LicenseDomainService organizationLicenseService;

    public String supportType() {
        return CockpitCommandType.ORGANIZATION.name();
    }

    public Single<OrganizationReply> handle(OrganizationCommand command) {
        OrganizationCommandPayload organizationPayload = (OrganizationCommandPayload)command.getPayload();
        try {
            OrganizationEntity organization = this.createOrUpdateOrganization(organizationPayload);
            this.handleLicense(organization, ((OrganizationCommandPayload)command.getPayload()).license());
            this.handleAccessPoints(organizationPayload, organization);
            log.info("Organization [{}] handled with id [{}].", (Object)organization.getName(), (Object)organization.getId());
            return Single.just((Object)new OrganizationReply(command.getId()));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when handling organization [%s] with id [%s].".formatted(organizationPayload.name(), organizationPayload.id());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new OrganizationReply(command.getId(), errorDetails));
        }
    }

    private void handleAccessPoints(OrganizationCommandPayload organizationPayload, OrganizationEntity organization) {
        List<Object> accessPointsToCreate = organizationPayload.accessPoints() != null ? organizationPayload.accessPoints().stream().map(cockpitAccessPoint -> AccessPoint.builder().referenceType(AccessPoint.ReferenceType.ORGANIZATION).referenceId(organization.getId()).target(AccessPoint.Target.valueOf(cockpitAccessPoint.getTarget().name())).host(cockpitAccessPoint.getHost()).secured(cockpitAccessPoint.isSecured()).overriding(cockpitAccessPoint.isOverriding()).build()).toList() : new ArrayList();
        this.accessPointService.updateAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organization.getId(), accessPointsToCreate);
    }

    private void handleLicense(OrganizationEntity organization, String license) {
        this.organizationLicenseService.createOrUpdateOrganizationLicense(organization.getId(), license);
    }

    private OrganizationEntity createOrUpdateOrganization(OrganizationCommandPayload organizationPayload) {
        String organizationId = this.getOrganizationId(organizationPayload);
        UpdateOrganizationEntity newOrganization = new UpdateOrganizationEntity();
        newOrganization.setCockpitId(organizationPayload.cockpitId());
        newOrganization.setHrids(organizationPayload.hrids());
        newOrganization.setName(organizationPayload.name());
        newOrganization.setDescription(organizationPayload.description());
        return this.organizationService.createOrUpdate(organizationId, newOrganization);
    }

    private String getOrganizationId(OrganizationCommandPayload organizationPayload) {
        try {
            OrganizationEntity byCockpitId = this.organizationService.findByCockpitId(organizationPayload.cockpitId());
            return byCockpitId.getId();
        }
        catch (OrganizationNotFoundException ex) {
            return organizationPayload.id();
        }
    }

    @Generated
    public OrganizationCommandHandler(OrganizationService organizationService, AccessPointCrudService accessPointService, LicenseDomainService organizationLicenseService) {
        this.organizationService = organizationService;
        this.accessPointService = accessPointService;
        this.organizationLicenseService = organizationLicenseService;
    }
}

