/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserMembership;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface MembershipService {
    public MemberEntity addRoleToMemberOnReference(ExecutionContext var1, MembershipReference var2, MembershipMember var3, MembershipRole var4);

    public MemberEntity addRoleToMemberOnReference(ExecutionContext var1, MembershipReferenceType var2, String var3, MembershipMemberType var4, String var5, String var6);

    public MemberEntity addRoleToMemberOnReference(ExecutionContext var1, MembershipReferenceType var2, String var3, MembershipMemberType var4, String var5, String var6, String var7);

    public void deleteMembership(ExecutionContext var1, String var2);

    public void deleteReference(ExecutionContext var1, MembershipReferenceType var2, String var3);

    public void deleteReferenceMember(ExecutionContext var1, MembershipReferenceType var2, String var3, MembershipMemberType var4, String var5);

    public void deleteReferenceMemberBySource(ExecutionContext var1, MembershipReferenceType var2, String var3, MembershipMemberType var4, String var5, String var6);

    public List<UserMembership> findUserMembership(ExecutionContext var1, MembershipReferenceType var2, String var3);

    public List<UserMembership> findUserMembershipBySource(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4);

    public Metadata findUserMembershipMetadata(List<UserMembership> var1, MembershipReferenceType var2);

    public Page<MemberEntity> getMembersByReference(ExecutionContext var1, MembershipReferenceType var2, String var3, Pageable var4);

    public Set<MemberEntity> getMembersByReference(ExecutionContext var1, MembershipReferenceType var2, String var3);

    public Page<MemberEntity> getMembersByReference(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4, Pageable var5);

    public Set<MemberEntity> getMembersByReference(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4);

    public Page<MemberEntity> getMembersByReferenceAndRole(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4, Pageable var5);

    public Set<MemberEntity> getMembersByReferenceAndRole(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4);

    public Page<MemberEntity> getMembersByReferencesAndRole(ExecutionContext var1, MembershipReferenceType var2, List<String> var3, String var4, Pageable var5);

    public Set<MemberEntity> getMembersByReferencesAndRole(ExecutionContext var1, MembershipReferenceType var2, List<String> var3, String var4);

    public Set<MembershipEntity> getMembershipsByMember(MembershipMemberType var1, String var2);

    public Set<MembershipEntity> getMembershipsByMemberAndReference(MembershipMemberType var1, String var2, MembershipReferenceType var3);

    public Set<String> getReferenceIdsByMemberAndReference(MembershipMemberType var1, String var2, MembershipReferenceType var3);

    public Set<MembershipEntity> getMembershipsByMemberAndReferenceAndRole(MembershipMemberType var1, String var2, MembershipReferenceType var3, String var4);

    public Set<MembershipEntity> getMembershipsByMemberAndReferenceAndRoleIn(MembershipMemberType var1, String var2, MembershipReferenceType var3, Collection<String> var4);

    public Set<String> getReferenceIdsByMemberAndReferenceAndRoleIn(MembershipMemberType var1, String var2, MembershipReferenceType var3, Collection<String> var4);

    public Set<MembershipEntity> getMembershipsByMembersAndReference(MembershipMemberType var1, List<String> var2, MembershipReferenceType var3);

    public Set<MembershipEntity> getMembershipsByReference(MembershipReferenceType var1, String var2);

    public Set<MembershipEntity> getMembershipsByReferenceAndRole(MembershipReferenceType var1, String var2, String var3);

    public Set<MembershipEntity> getMembershipsByReferencesAndRole(MembershipReferenceType var1, List<String> var2, String var3);

    public MembershipEntity getPrimaryOwner(String var1, MembershipReferenceType var2, String var3);

    public String getPrimaryOwnerUserId(String var1, MembershipReferenceType var2, String var3);

    public Set<RoleEntity> getRoles(MembershipReferenceType var1, String var2, MembershipMemberType var3, String var4);

    public MemberEntity getUserMember(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4);

    public Map<String, char[]> getUserMemberPermissions(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4);

    public Map<String, char[]> getUserMemberPermissions(ExecutionContext var1, GenericApiEntity var2, String var3);

    public Map<String, char[]> getUserMemberPermissions(ExecutionContext var1, ApplicationEntity var2, String var3);

    public Map<String, char[]> getUserMemberPermissions(ExecutionContext var1, GroupEntity var2, String var3);

    public Map<String, char[]> getUserMemberPermissions(ExecutionContext var1, EnvironmentEntity var2, String var3);

    public void removeRole(MembershipReferenceType var1, String var2, MembershipMemberType var3, String var4, String var5);

    public void removeRoleUsage(String var1, String var2);

    public void removeMemberMemberships(ExecutionContext var1, MembershipMemberType var2, String var3);

    public void transferApiOwnership(ExecutionContext var1, String var2, MembershipMember var3, List<RoleEntity> var4);

    public void transferApplicationOwnership(ExecutionContext var1, String var2, MembershipMember var3, List<RoleEntity> var4);

    public void transferOwnership(ExecutionContext var1, MembershipReferenceType var2, RoleScope var3, String var4, MembershipMember var5, List<RoleEntity> var6);

    public MemberEntity updateRoleToMemberOnReference(ExecutionContext var1, MembershipReference var2, MembershipMember var3, MembershipRole var4);

    public List<MemberEntity> updateRolesToMemberOnReference(ExecutionContext var1, MembershipReference var2, MembershipMember var3, Collection<MembershipRole> var4, String var5, boolean var6);

    public List<MemberEntity> updateRolesToMemberOnReferenceBySource(ExecutionContext var1, MembershipReference var2, MembershipMember var3, Collection<MembershipRole> var4, String var5);

    public MemberEntity createNewMembership(ExecutionContext var1, MembershipReferenceType var2, String var3, String var4, String var5, String var6);

    public MemberEntity updateMembershipForApi(ExecutionContext var1, String var2, String var3, String var4);

    public void deleteMemberForApi(ExecutionContext var1, String var2, String var3);

    public void deleteMemberForApplication(ExecutionContext var1, String var2, String var3);

    public MemberEntity createNewMembershipForIntegration(ExecutionContext var1, String var2, String var3, String var4, String var5);

    public MemberEntity updateMembershipForIntegration(ExecutionContext var1, String var2, String var3, String var4);

    public void deleteMemberForIntegration(ExecutionContext var1, String var2, String var3);

    public void invalidateRoleCache(String var1, String var2, String var3, String var4);

    public static class Membership {
        final MembershipReference reference;
        final MembershipMember member;
        final MembershipRole role;
        String source;

        public Membership(MembershipReference reference, MembershipMember member, MembershipRole role) {
            this.reference = reference;
            this.member = member;
            this.role = role;
        }

        public MembershipReference getReference() {
            return this.reference;
        }

        public MembershipMember getMember() {
            return this.member;
        }

        public MembershipRole getRole() {
            return this.role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }
    }

    public static class MembershipRole {
        private final RoleScope scope;
        private final String name;

        public MembershipRole(RoleScope scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public RoleScope getScope() {
            return this.scope;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MembershipRole that = (MembershipRole)o;
            if (this.scope != that.scope) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.scope.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return "MembershipRole{scope=" + String.valueOf(this.scope) + ", name='" + this.name + "'}";
        }
    }

    public static class MembershipMember {
        private final String memberId;
        private final String reference;
        private final MembershipMemberType memberType;

        public MembershipMember(String memberId, String reference, MembershipMemberType memberType) {
            this.memberId = memberId;
            this.reference = reference;
            this.memberType = memberType;
        }

        public String getMemberId() {
            return this.memberId;
        }

        public String getReference() {
            return this.reference;
        }

        public MembershipMemberType getMemberType() {
            return this.memberType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MembershipMember that = (MembershipMember)o;
            if (this.memberId != null ? !this.memberId.equals(that.memberId) : that.memberId != null) {
                return false;
            }
            return this.reference != null ? this.reference.equals(that.reference) : that.reference == null;
        }

        public int hashCode() {
            int result = this.memberId != null ? this.memberId.hashCode() : 0;
            result = 31 * result + (this.reference != null ? this.reference.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "MembershipMember{memberId='" + this.memberId + "', reference='" + this.reference + "', memberType=" + String.valueOf(this.memberType) + "}";
        }
    }

    public static class MembershipReference {
        private final MembershipReferenceType type;
        private final String id;

        public MembershipReference(MembershipReferenceType type, String id) {
            this.type = type;
            this.id = id;
        }

        public MembershipReferenceType getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MembershipReference that = (MembershipReference)o;
            if (this.type != that.type) {
                return false;
            }
            return this.id.equals(that.id);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public String toString() {
            return "MembershipReference{type=" + String.valueOf(this.type) + ", id='" + this.id + "'}";
        }
    }
}

