/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.plugin;

import com.google.common.annotations.VisibleForTesting;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.rest.api.common.apiservices.DefaultManagementDeploymentContext;
import io.gravitee.apim.rest.api.common.apiservices.ManagementApiService;
import io.gravitee.apim.rest.api.common.apiservices.ManagementApiServiceFactory;
import io.gravitee.common.service.AbstractService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.AbstractApi;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.gateway.reactive.api.apiservice.ApiService;
import io.gravitee.plugin.apiservice.ApiServicePluginManager;
import io.reactivex.rxjava3.core.Completable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ManagementApiServicesManager
extends AbstractService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagementApiServicesManager.class);
    private final ApiServicePluginManager apiServicePluginManager;
    @VisibleForTesting
    final Map<String, List<ManagementApiService>> servicesByApi = new ConcurrentHashMap<String, List<ManagementApiService>>();

    public ManagementApiServicesManager(ApplicationContext applicationContext, ApiServicePluginManager apiServicePluginManager) {
        this.apiServicePluginManager = apiServicePluginManager;
        this.applicationContext = applicationContext;
    }

    protected void doStop() throws Exception {
        super.doStop();
        log.info("Gracefully stopping ManagementApiServices");
        ManagementApiServicesManager.stopManagementApiServices(this.servicesByApi.values().stream().flatMap(Collection::stream));
    }

    public void deployServices(Api api) {
        log.debug("Deploying services for api: {}", (Object)api.getId());
        if (!api.getDefinitionVersion().equals((Object)DefinitionVersion.V4)) {
            return;
        }
        List services = this.apiServicePluginManager.getAllFactories(ManagementApiServiceFactory.class).stream().map(managementApiServiceFactory -> managementApiServiceFactory.createService(api.getType() == ApiType.NATIVE ? new DefaultManagementDeploymentContext(api.getApiDefinitionNativeV4(), this.applicationContext) : new DefaultManagementDeploymentContext(api.getApiDefinitionHttpV4(), this.applicationContext))).filter(Objects::nonNull).collect(Collectors.toList());
        Completable.concat((Iterable)services.stream().map(ApiService::start).collect(Collectors.toList())).doOnError(throwable -> log.error("Unable to start management-api-service: {}", (Object)throwable.getMessage(), throwable)).blockingAwait();
        if (!services.isEmpty()) {
            this.servicesByApi.put(api.getId(), services);
        }
    }

    public void undeployServices(Api api) {
        log.debug("Undeploying services for api: {}", (Object)api.getId());
        List<ManagementApiService> apiServices = this.servicesByApi.get(api.getId());
        if (apiServices != null && !apiServices.isEmpty()) {
            ManagementApiServicesManager.stopManagementApiServices(apiServices.stream());
        }
        this.servicesByApi.remove(api.getId());
    }

    public void startDynamicProperties(Api api) {
        if (!api.getDefinitionVersion().equals((Object)DefinitionVersion.V4)) {
            return;
        }
        List services = this.apiServicePluginManager.getAllFactories(ManagementApiServiceFactory.class).stream().map(managementApiServiceFactory -> managementApiServiceFactory.createService(new DefaultManagementDeploymentContext(api.getApiDefinitionHttpV4(), this.applicationContext))).filter(Objects::nonNull).filter(service -> "http-dynamic-properties".equals(service.id())).collect(Collectors.toList());
        Completable.concat((Iterable)services.stream().map(ApiService::start).collect(Collectors.toList())).doOnError(throwable -> log.error("Unable to start dynamic-api-service for api {}", (Object)api.getId(), throwable)).blockingAwait();
        if (!services.isEmpty() && !services.isEmpty()) {
            this.servicesByApi.computeIfAbsent(api.getId(), k -> new ArrayList()).addAll(services);
        }
    }

    public void updateServices(Api api) {
        log.debug("Restarting services for api: {}", (Object)api.getId());
        List<ManagementApiService> managedApi = this.servicesByApi.get(api.getId());
        if (managedApi != null && !managedApi.isEmpty()) {
            Completable.concat((Iterable)managedApi.stream().map(managementApiService -> managementApiService.update((AbstractApi)api.getApiDefinitionHttpV4())).collect(Collectors.toList())).blockingAwait();
            return;
        }
        this.deployServices(api);
    }

    private static void stopManagementApiServices(Stream<ManagementApiService> apiServices) {
        Completable.concat((Iterable)apiServices.map(ApiService::stop).collect(Collectors.toList())).blockingAwait();
    }

    public void stopDynamicProperties(Api api) {
        Optional.ofNullable(this.servicesByApi.get(api.getId())).flatMap(services -> services.stream().filter(service -> "http-dynamic-properties".equals(service.id())).findFirst()).ifPresent(service -> service.stop().blockingAwait());
        if (this.servicesByApi.get(api.getId()) != null) {
            this.servicesByApi.get(api.getId()).removeIf(service -> "http-dynamic-properties".equals(service.id()));
        }
    }
}

