/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.specgen.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.specgen.model.ApiSpecGen;
import io.gravitee.apim.core.specgen.query_service.ApiSpecGenQueryService;
import io.gravitee.apim.core.specgen.service_provider.OasProvider;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class BuildSpecGenPageResponseUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildSpecGenPageResponseUseCase.class);
    public static final String POWERED_BY = "poweredBy";
    public static final String NEWT_AI = "NewtAI";
    public static final Map<String, String> METADATA = Map.of("poweredBy", "NewtAI");
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private final ApiSpecGenQueryService queryService;
    private final OasProvider oasProvider;

    public Maybe<Page> execute(Input input) {
        return this.queryService.rxFindByIdAndType(GraviteeContext.getExecutionContext(), input.apiId(), ApiType.PROXY).observeOn(Schedulers.computation()).map(api -> BuildSpecGenPageResponseUseCase.buildPage(api, this.oasProvider.decorateSpecification((ApiSpecGen)api, input.content()))).observeOn(Schedulers.io());
    }

    private static Page buildPage(ApiSpecGen api, String rawSpec) {
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN));
        return Page.builder().referenceId(api.id()).referenceType(Page.ReferenceType.API).name(api.name() + " by Newt - " + now).content(rawSpec).type(Page.Type.SWAGGER).visibility(Page.Visibility.PRIVATE).homepage(false).published(false).metadata(METADATA).build();
    }

    @Generated
    public BuildSpecGenPageResponseUseCase(ApiSpecGenQueryService queryService, OasProvider oasProvider) {
        this.queryService = queryService;
        this.oasProvider = oasProvider;
    }

    public record Input(String apiId, String content) {
    }
}

