/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.flow.domain_service.FlowValidationDomainService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.PlanSynchronizationService;
import io.gravitee.apim.core.plan.domain_service.PlanValidatorDomainService;
import io.gravitee.apim.core.plan.domain_service.ReorderPlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DomainService
public class UpdatePlanDomainService {
    private final PlanQueryService planQueryService;
    private final PlanCrudService planCrudService;
    private final PlanValidatorDomainService planValidatorDomainService;
    private final FlowValidationDomainService flowValidationDomainService;
    private final FlowCrudService flowCrudService;
    private final AuditDomainService auditService;
    private final PlanSynchronizationService planSynchronizationService;
    private final ReorderPlanDomainService reorderPlanDomainService;

    public UpdatePlanDomainService(PlanQueryService planQueryService, PlanCrudService planCrudService, PlanValidatorDomainService planValidatorDomainService, FlowValidationDomainService flowValidationDomainService, FlowCrudService flowCrudService, AuditDomainService auditService, PlanSynchronizationService planSynchronizationService, ReorderPlanDomainService reorderPlanDomainService) {
        this.planQueryService = planQueryService;
        this.planCrudService = planCrudService;
        this.planValidatorDomainService = planValidatorDomainService;
        this.flowValidationDomainService = flowValidationDomainService;
        this.flowCrudService = flowCrudService;
        this.auditService = auditService;
        this.planSynchronizationService = planSynchronizationService;
        this.reorderPlanDomainService = reorderPlanDomainService;
    }

    public void bulkUpdate(List<Plan> plansToUpdate, Map<String, PlanStatus> existingPlanStatuses, Map<String, List<? extends AbstractFlow>> flows, Api api, AuditInfo auditInfo) {
        Objects.requireNonNull(existingPlanStatuses, "existingPlanStatuses must not be null");
        Objects.requireNonNull(flows, "flows must not be null");
        block5: for (Plan planToUpdate : plansToUpdate) {
            switch (planToUpdate.getDefinitionVersion()) {
                case V4: {
                    this.updateV4ApiPlan(planToUpdate, flows.get(planToUpdate.getId()), existingPlanStatuses, api, auditInfo, (existing, update) -> this.planCrudService.update((Plan)update));
                    continue block5;
                }
                case FEDERATED: {
                    this.updateFederatedApiPlan(planToUpdate, auditInfo);
                    continue block5;
                }
                case V2: {
                    this.updateV2ApiPlan(planToUpdate, existingPlanStatuses, api, auditInfo);
                    continue block5;
                }
            }
            throw new IllegalStateException(String.valueOf(api.getDefinitionVersion()) + " is not supported");
        }
    }

    public Plan update(Plan planToUpdate, List<? extends AbstractFlow> flows, Map<String, PlanStatus> existingPlanStatuses, Api api, AuditInfo auditInfo) {
        return switch (planToUpdate.getDefinitionVersion()) {
            case DefinitionVersion.V4 -> {
                if (existingPlanStatuses == null) {
                    existingPlanStatuses = this.getPlanStatusMap(api);
                }
                yield this.updateV4ApiPlan(planToUpdate, flows, existingPlanStatuses, api, auditInfo, this::orderAwareUpdate);
            }
            case DefinitionVersion.FEDERATED -> this.updateFederatedApiPlan(planToUpdate, auditInfo);
            case DefinitionVersion.V2 -> {
                if (existingPlanStatuses == null) {
                    existingPlanStatuses = this.getPlanStatusMap(api);
                }
                yield this.updateV2ApiPlan(planToUpdate, existingPlanStatuses, api, auditInfo);
            }
            default -> throw new IllegalStateException(String.valueOf(api.getDefinitionVersion()) + " is not supported");
        };
    }

    private Map<String, PlanStatus> getPlanStatusMap(Api api) {
        List<Plan> existingPlans = this.planQueryService.findAllByApiId(api.getId());
        return existingPlans.stream().collect(Collectors.toMap(Plan::getId, Plan::getPlanStatus));
    }

    private Plan updateV4ApiPlan(Plan planToUpdate, List<? extends AbstractFlow> flows, Map<String, PlanStatus> existingPlanStatuses, Api api, AuditInfo auditInfo, BinaryOperator<Plan> updateFunction) {
        this.updatePreFlightChecks(planToUpdate, existingPlanStatuses, api, auditInfo);
        Plan existingPlan = this.planCrudService.getById(planToUpdate.getId());
        Plan updatePlan = existingPlan.update(planToUpdate);
        if (api.isNative()) {
            return this.updateNativeV4ApiPlan(existingPlan, updatePlan, flows, auditInfo, updateFunction);
        }
        return this.updateHttpV4ApiPlan(existingPlan, updatePlan, flows, api, auditInfo, updateFunction);
    }

    private Plan updateV2ApiPlan(Plan planToUpdate, Map<String, PlanStatus> existingPlanStatuses, Api api, AuditInfo auditInfo) {
        this.updatePreFlightChecks(planToUpdate, existingPlanStatuses, api, auditInfo);
        Plan existingPlan = this.planCrudService.getById(planToUpdate.getId());
        Plan updatePlan = existingPlan.update(planToUpdate);
        if (!this.planSynchronizationService.checkSynchronized(existingPlan, List.of(), updatePlan, List.of())) {
            updatePlan.setNeedRedeployAt(Date.from(updatePlan.getUpdatedAt().toInstant()));
        }
        Plan updated = this.orderAwareUpdate(existingPlan, updatePlan);
        this.createAuditLog(existingPlan, updated, auditInfo);
        return updated;
    }

    private Plan updateHttpV4ApiPlan(Plan existingPlan, Plan updatePlan, List<Flow> flows, Api api, AuditInfo auditInfo, BinaryOperator<Plan> updateFunction) {
        List<Flow> sanitizedFlows = this.flowValidationDomainService.validateAndSanitizeHttpV4(api.getType(), flows);
        this.flowValidationDomainService.validatePathParameters(api.getType(), api.getApiDefinitionHttpV4().getFlows() != null ? api.getApiDefinitionHttpV4().getFlows().stream() : Stream.empty(), sanitizedFlows.stream());
        if (!this.planSynchronizationService.checkSynchronized(existingPlan, List.of(), updatePlan, sanitizedFlows)) {
            updatePlan.setNeedRedeployAt(Date.from(updatePlan.getUpdatedAt().toInstant()));
        }
        Plan updated = (Plan)updateFunction.apply(existingPlan, updatePlan);
        this.flowCrudService.savePlanFlows(updated.getId(), sanitizedFlows);
        this.createAuditLog(existingPlan, updated, auditInfo);
        return updated;
    }

    private Plan updateNativeV4ApiPlan(Plan existingPlan, Plan updatePlan, List<NativeFlow> flows, AuditInfo auditInfo, BinaryOperator<Plan> updateFunction) {
        List<NativeFlow> sanitizedNativeFlows = this.flowValidationDomainService.validateAndSanitizeNativeV4(flows);
        if (!this.planSynchronizationService.checkNativePlanSynchronized(existingPlan, List.of(), updatePlan, sanitizedNativeFlows)) {
            updatePlan.setNeedRedeployAt(Date.from(updatePlan.getUpdatedAt().toInstant()));
        }
        Plan updated = (Plan)updateFunction.apply(existingPlan, updatePlan);
        this.flowCrudService.saveNativePlanFlows(updated.getId(), sanitizedNativeFlows);
        this.createAuditLog(existingPlan, updated, auditInfo);
        return updated;
    }

    private Plan updateFederatedApiPlan(Plan planToUpdate, AuditInfo auditInfo) {
        this.planValidatorDomainService.validateGeneralConditionsPageStatus(planToUpdate);
        Plan existingPlan = this.planCrudService.getById(planToUpdate.getId());
        if (existingPlan.getPlanStatus() == PlanStatus.CLOSED && existingPlan.getPlanStatus() != planToUpdate.getPlanStatus()) {
            throw new ValidationDomainException("Invalid status for planToUpdate '" + planToUpdate.getName() + "'");
        }
        Plan toUpdate = existingPlan.update(planToUpdate);
        Plan updated = this.orderAwareUpdate(existingPlan, toUpdate);
        this.createAuditLog(existingPlan, updated, auditInfo);
        return updated;
    }

    private Plan orderAwareUpdate(Plan existingPlan, Plan planToUpdate) {
        if (planToUpdate.getOrder() != existingPlan.getOrder()) {
            return this.reorderPlanDomainService.reorderAfterUpdate(planToUpdate);
        }
        return this.planCrudService.update(planToUpdate);
    }

    private void updatePreFlightChecks(Plan planToUpdate, Map<String, PlanStatus> existingPlanStatuses, Api api, AuditInfo auditInfo) {
        if (existingPlanStatuses.containsKey(planToUpdate.getId()) && existingPlanStatuses.get(planToUpdate.getId()) == PlanStatus.CLOSED && existingPlanStatuses.get(planToUpdate.getId()) != planToUpdate.getPlanStatus()) {
            throw new ValidationDomainException("Invalid status for plan '" + planToUpdate.getName() + "'");
        }
        this.planValidatorDomainService.validatePlanSecurity(planToUpdate, auditInfo.organizationId(), auditInfo.environmentId(), api.getType());
        this.planValidatorDomainService.validatePlanTagsAgainstApiTags(planToUpdate.getTags(), api.getTags());
        this.planValidatorDomainService.validateGeneralConditionsPageStatus(planToUpdate);
    }

    private void createAuditLog(Plan oldPlan, Plan newPlan, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(newPlan.getApiId()).event(PlanAuditEvent.PLAN_UPDATED).actor(auditInfo.actor()).oldValue(oldPlan).newValue(newPlan).createdAt(newPlan.getUpdatedAt()).properties(Map.of(AuditProperties.PLAN, newPlan.getId())).build());
    }
}

