/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.cluster.crud_service.ClusterCrudService;
import io.gravitee.apim.core.cluster.model.ClusterAuditEvent;
import io.gravitee.common.utils.TimeProvider;
import java.util.Map;
import lombok.Generated;

@UseCase
public class DeleteClusterUseCase {
    private final ClusterCrudService clusterCrudService;
    private final AuditDomainService auditService;

    public Output execute(Input input) {
        this.clusterCrudService.delete(input.clusterId, input.auditInfo.environmentId());
        this.createAuditLog(input.clusterId, input.auditInfo());
        return new Output();
    }

    private void createAuditLog(String deletedClusterId, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(ClusterAuditEvent.CLUSTER_DELETED).actor(auditInfo.actor()).newValue(null).createdAt(TimeProvider.now()).properties(Map.of(AuditProperties.CLUSTER, deletedClusterId)).build());
    }

    @Generated
    public DeleteClusterUseCase(ClusterCrudService clusterCrudService, AuditDomainService auditService) {
        this.clusterCrudService = clusterCrudService;
        this.auditService = auditService;
    }

    public record Input(String clusterId, AuditInfo auditInfo) {
    }

    public record Output() {
    }
}

