/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.cluster.crud_service.ClusterCrudService;
import io.gravitee.apim.core.cluster.domain_service.ValidateClusterService;
import io.gravitee.apim.core.cluster.model.Cluster;
import io.gravitee.apim.core.cluster.model.ClusterAuditEvent;
import io.gravitee.apim.core.cluster.model.CreateCluster;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Map;
import lombok.Generated;

@UseCase
public class CreateClusterUseCase {
    private final ClusterCrudService clusterCrudService;
    private final ValidateClusterService validateClusterService;
    private final AuditDomainService auditService;
    private final MembershipCrudService membershipCrudService;
    private final RoleQueryService roleQueryService;

    public Output execute(Input input) {
        Instant now = TimeProvider.instantNow();
        Cluster clusterToCreate = Cluster.builder().name(input.createCluster.getName()).description(input.createCluster.getDescription()).configuration(input.createCluster.getConfiguration()).id(UuidString.generateRandom()).createdAt(now).updatedAt(now).environmentId(input.auditInfo().environmentId()).organizationId(input.auditInfo().organizationId()).build();
        this.validateClusterService.validate(clusterToCreate);
        Cluster createdCluster = this.clusterCrudService.create(clusterToCreate);
        this.createClusterPrimaryOwner(input.auditInfo.actor().userId(), createdCluster.getId(), now);
        this.createAuditLog(createdCluster, input.auditInfo());
        return new Output(createdCluster);
    }

    private Membership createClusterPrimaryOwner(String memberId, String clusterId, Instant createdAt) {
        ZonedDateTime createdAtZonedDateTime = createdAt.atZone(TimeProvider.clock().getZone());
        Role role = this.roleQueryService.findByScopeAndNameAndOrganizationId(Role.Scope.CLUSTER, "PRIMARY_OWNER", GraviteeContext.getExecutionContext().getOrganizationId()).orElseThrow();
        Membership membership = Membership.builder().id(UuidString.generateRandom()).memberId(memberId).memberType(Membership.Type.USER).referenceId(clusterId).referenceType(Membership.ReferenceType.CLUSTER).roleId(role.getId()).createdAt(createdAtZonedDateTime).updatedAt(createdAtZonedDateTime).build();
        return this.membershipCrudService.create(membership);
    }

    private void createAuditLog(Cluster cluster, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(ClusterAuditEvent.CLUSTER_CREATED).actor(auditInfo.actor()).newValue(cluster).createdAt(cluster.getCreatedAt().atZone(TimeProvider.clock().getZone())).properties(Map.of(AuditProperties.CLUSTER, cluster.getId())).build());
    }

    @Generated
    public CreateClusterUseCase(ClusterCrudService clusterCrudService, ValidateClusterService validateClusterService, AuditDomainService auditService, MembershipCrudService membershipCrudService, RoleQueryService roleQueryService) {
        this.clusterCrudService = clusterCrudService;
        this.validateClusterService = validateClusterService;
        this.auditService = auditService;
        this.membershipCrudService = membershipCrudService;
        this.roleQueryService = roleQueryService;
    }

    public record Input(CreateCluster createCluster, AuditInfo auditInfo) {
    }

    public record Output(Cluster cluster) {
    }
}

