/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiWorkflowStateService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiWorkflowStateServiceImpl
implements ApiWorkflowStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiWorkflowStateServiceImpl.class);
    private final AuditService auditService;
    private final ApiMetadataService apiMetadataService;
    private final WorkflowService workflowService;
    private final RoleService roleService;
    private final UserService userService;
    private final NotifierService notifierService;
    private final MembershipService membershipService;
    private final EmailService emailService;
    private final ApiSearchService apiSearchService;
    private final ParameterService parameterService;

    public ApiWorkflowStateServiceImpl(AuditService auditService, @Lazy ApiMetadataService apiMetadataService, WorkflowService workflowService, @Lazy RoleService roleService, UserService userService, NotifierService notifierService, MembershipService membershipService, EmailService emailService, ApiSearchService apiSearchService, ParameterService parameterService) {
        this.auditService = auditService;
        this.apiMetadataService = apiMetadataService;
        this.workflowService = workflowService;
        this.roleService = roleService;
        this.userService = userService;
        this.notifierService = notifierService;
        this.membershipService = membershipService;
        this.emailService = emailService;
        this.apiSearchService = apiSearchService;
        this.parameterService = parameterService;
    }

    @Override
    public GenericApiEntity askForReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        log.debug("Ask for review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.ASK_FOR_REVIEW, WorkflowState.IN_REVIEW, reviewEntity);
    }

    @Override
    public GenericApiEntity acceptReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        log.debug("Accept review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.REVIEW_OK, WorkflowState.REVIEW_OK, reviewEntity);
    }

    @Override
    public GenericApiEntity rejectReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        log.debug("Reject review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.REQUEST_FOR_CHANGES, WorkflowState.REQUEST_FOR_CHANGES, reviewEntity);
    }

    private GenericApiEntity updateWorkflowReview(ExecutionContext executionContext, String apiId, String userId, ApiHook hook, WorkflowState workflowState, ReviewEntity reviewEntity) {
        List<String> reviewersEmail;
        String workflowMessage = reviewEntity == null ? null : reviewEntity.getMessage();
        Workflow workflow = this.workflowService.create(WorkflowReferenceType.API, apiId, WorkflowType.REVIEW, userId, workflowState, workflowMessage);
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
        UserEntity user = this.userService.findById(executionContext, userId);
        GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, genericApiEntity);
        this.notifierService.trigger(executionContext, hook, genericApiEntity.getId(), new NotificationParamsBuilder().api(apiWithMetadata).user(user).build());
        if (hook.equals(ApiHook.ASK_FOR_REVIEW) && (reviewersEmail = this.findAllReviewersEmail(executionContext, genericApiEntity)).size() > 0) {
            this.emailService.sendAsyncEmailNotification(executionContext, new EmailNotificationBuilder().params(new NotificationParamsBuilder().api(genericApiEntity).user(user).build()).to(reviewersEmail.toArray(new String[reviewersEmail.size()])).template(EmailNotificationBuilder.EmailTemplate.API_ASK_FOR_REVIEW).build());
        }
        HashMap<Audit.AuditProperties, String> properties = new HashMap<Audit.AuditProperties, String>();
        properties.put(Audit.AuditProperties.USER, userId);
        properties.put(Audit.AuditProperties.API, genericApiEntity.getId());
        Workflow.AuditEvent evtType = null;
        switch (workflowState) {
            case REQUEST_FOR_CHANGES: {
                evtType = Workflow.AuditEvent.API_REVIEW_REJECTED;
                break;
            }
            case REVIEW_OK: {
                evtType = Workflow.AuditEvent.API_REVIEW_ACCEPTED;
                break;
            }
            default: {
                evtType = Workflow.AuditEvent.API_REVIEW_ASKED;
            }
        }
        this.auditService.createApiAuditLog(executionContext, AuditService.AuditLogData.builder().properties(properties).event((Audit.AuditEvent)evtType).createdAt(new Date()).oldValue(null).newValue(workflow).build(), genericApiEntity.getId());
        return genericApiEntity;
    }

    private List<String> findAllReviewersEmail(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        RolePermissionAction[] acls = new RolePermissionAction[]{RolePermissionAction.UPDATE};
        boolean isTrialInstance = this.parameterService.findAsBoolean(executionContext, Key.TRIAL_INSTANCE, ParameterReferenceType.SYSTEM);
        Predicate<UserEntity> excludeIfTrialAndNotOptedIn = userEntity -> !isTrialInstance || userEntity.optedIn();
        Set reviewerEmails = this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.API, genericApiEntity.getId(), role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(id -> this.userService.findById(executionContext, (String)id)).filter(excludeIfTrialAndNotOptedIn).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet());
        Set groups = genericApiEntity.getGroups();
        if (groups != null && !groups.isEmpty()) {
            groups.forEach(group -> reviewerEmails.addAll(this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.GROUP, (String)group, role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(id -> this.userService.findById(executionContext, (String)id)).filter(excludeIfTrialAndNotOptedIn).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet())));
        }
        return new ArrayList<String>(reviewerEmails);
    }
}

