/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.designer.DeployModelCommand;
import io.gravitee.cockpit.api.command.v1.designer.DeployModelCommandPayload;
import io.gravitee.cockpit.api.command.v1.designer.DeployModelReply;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntityResult;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.ApiServiceCockpit;
import io.gravitee.rest.api.service.cockpit.services.CockpitApiPermissionChecker;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployModelCommandHandler
implements CommandHandler<DeployModelCommand, DeployModelReply> {
    private final Logger logger = LoggerFactory.getLogger(DeployModelCommandHandler.class);
    private final ApiSearchService apiSearchService;
    private final ApiServiceCockpit cockpitApiService;
    private final CockpitApiPermissionChecker permissionChecker;
    private final UserService userService;
    private final EnvironmentService environmentService;

    public String supportType() {
        return CockpitCommandType.DEPLOY_MODEL.name();
    }

    public Single<DeployModelReply> handle(DeployModelCommand command) {
        DeployModelCommandPayload payload = (DeployModelCommandPayload)command.getPayload();
        String apiCrossId = payload.modelId();
        String userId = payload.userId();
        String swaggerDefinition = payload.swaggerDefinition();
        String environmentId = payload.environmentId();
        DeploymentMode mode = DeploymentMode.fromDeployModelPayload(payload);
        List labels = payload.labels();
        try {
            ApiEntityResult result;
            EnvironmentEntity environment = this.getEnvironment(environmentId);
            ExecutionContext executionContext = new ExecutionContext(environment);
            UserEntity user = this.userService.findBySource(executionContext.getOrganizationId(), "cockpit", userId, true);
            SecurityContextHelper.authenticateAs(user);
            Optional<String> optApiId = this.apiSearchService.findIdByEnvironmentIdAndCrossId(executionContext.getEnvironmentId(), apiCrossId);
            if (optApiId.isPresent()) {
                String apiId = optApiId.get();
                Api api = this.apiSearchService.findRepositoryApiById(executionContext, apiId);
                if (api.getDefinitionVersion() == DefinitionVersion.V4) {
                    return Single.just((Object)new DeployModelReply(command.getId(), "API migrated from v2 to v4. Update not yet supported."));
                }
                Optional<String> message = this.permissionChecker.checkUpdatePermission(executionContext, user.getId(), executionContext.getEnvironmentId(), apiId, mode);
                if (message.isPresent()) {
                    return Single.just((Object)new DeployModelReply(command.getId(), message.get()));
                }
                result = this.cockpitApiService.updateApi(executionContext, apiId, user.getId(), swaggerDefinition, executionContext.getEnvironmentId(), mode, labels);
            } else {
                Optional<String> message = this.permissionChecker.checkCreatePermission(executionContext, user.getId(), executionContext.getEnvironmentId(), mode);
                if (message.isPresent()) {
                    return Single.just((Object)new DeployModelReply(command.getId(), message.get()));
                }
                result = this.cockpitApiService.createApi(executionContext, apiCrossId, user.getId(), swaggerDefinition, executionContext.getEnvironmentId(), mode, labels);
            }
            if (result.isSuccess()) {
                this.logger.info("Api imported [{}].", (Object)result.getApi().getId());
                return Single.just((Object)new DeployModelReply(command.getId()));
            }
            String errorDetails = "Failed to import API [%s].".formatted(result.getErrorMessage());
            this.logger.error(errorDetails);
            return Single.just((Object)new DeployModelReply(command.getId(), errorDetails));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when importing api [%s]".formatted(payload.modelId());
            this.logger.error(errorDetails, (Throwable)e);
            return Single.just((Object)new DeployModelReply(command.getId(), errorDetails));
        }
    }

    private EnvironmentEntity getEnvironment(String environmentId) {
        try {
            return this.environmentService.findByCockpitId(environmentId);
        }
        catch (EnvironmentNotFoundException e) {
            return this.environmentService.findById(environmentId);
        }
    }

    @Generated
    public DeployModelCommandHandler(ApiSearchService apiSearchService, ApiServiceCockpit cockpitApiService, CockpitApiPermissionChecker permissionChecker, UserService userService, EnvironmentService environmentService) {
        this.apiSearchService = apiSearchService;
        this.cockpitApiService = cockpitApiService;
        this.permissionChecker = permissionChecker;
        this.userService = userService;
        this.environmentService = environmentService;
    }
}

