/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.tag;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.tag.model.Tag;
import io.gravitee.apim.core.tag.query_service.TagQueryService;
import io.gravitee.apim.infra.adapter.TagAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.TagRepository;
import io.gravitee.repository.management.model.TagReferenceType;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TagQueryServiceImpl
implements TagQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagQueryServiceImpl.class);
    private final TagRepository tagRepository;

    public TagQueryServiceImpl(@Lazy TagRepository tagRepository) {
        this.tagRepository = tagRepository;
    }

    @Override
    public List<Tag> findByName(String organizationId, String name) {
        try {
            log.debug("findByName {}", (Object)name);
            if (name == null) {
                return Collections.emptyList();
            }
            Set groups = this.tagRepository.findByReference(organizationId, TagReferenceType.ORGANIZATION);
            return groups.stream().filter(group -> group.getName().equals(name)).map(TagAdapter.INSTANCE::toModel).sorted(Comparator.comparing(Tag::getName)).toList();
        }
        catch (TechnicalException ex) {
            throw new TechnicalDomainException("An error occurs while trying to find tags by name", ex);
        }
    }
}

