/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.domain_service.ApiAnalyticsSpecification;
import io.gravitee.apim.core.analytics.model.StatsAnalytics;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchStatsUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchStatsUseCase.class);
    private final ApiCrudService apiCrudService;
    private final AnalyticsQueryService analyticsQueryService;

    public Output execute(ExecutionContext executionContext, Input input) {
        ApiAnalyticsSpecification.forSearchStatsAnalytics().throwIfNotSatisfied(this.apiCrudService.get(input.api()), executionContext, input.from(), input.to());
        AnalyticsQueryService.StatsQuery statsQuery = new AnalyticsQueryService.StatsQuery(AnalyticsQueryService.SearchTermId.forApi(input.api()), input.field(), Instant.ofEpochMilli(input.from()), Instant.ofEpochMilli(input.to()), input.query());
        StatsAnalytics result = this.analyticsQueryService.searchStatsAnalytics(executionContext, statsQuery).orElse(null);
        return new Output(result);
    }

    @Generated
    public SearchStatsUseCase(ApiCrudService apiCrudService, AnalyticsQueryService analyticsQueryService) {
        this.apiCrudService = apiCrudService;
        this.analyticsQueryService = analyticsQueryService;
    }

    public record Input(String api, long from, long to, String field, Optional<String> query) {
    }

    public record Output(StatsAnalytics analytics) {
    }
}

