/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PlanSecurityEntity;
import io.gravitee.rest.api.model.PlansConfigurationEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.gravitee.rest.api.model.v4.plan.BasePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.NewPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.model.v4.plan.UpdatePlanEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiDeprecatedException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.GroupNotFoundException;
import io.gravitee.rest.api.service.exceptions.KeylessPlanAlreadyPublishedException;
import io.gravitee.rest.api.service.exceptions.NativePlanAuthenticationConflictException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyDeprecatedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanFlowRequiredException;
import io.gravitee.rest.api.service.exceptions.PlanGeneralConditionStatusException;
import io.gravitee.rest.api.service.exceptions.PlanInvalidException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotYetPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanWithSubscriptionsException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedPlanSecurityTypeException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.processor.SynchronizationService;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.service.v4.PlanService;
import io.gravitee.rest.api.service.v4.mapper.GenericPlanMapper;
import io.gravitee.rest.api.service.v4.mapper.PlanMapper;
import io.gravitee.rest.api.service.v4.validation.FlowValidationService;
import io.gravitee.rest.api.service.v4.validation.PathParametersValidationService;
import io.gravitee.rest.api.service.v4.validation.TagsValidationService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="PlanServiceImplV4")
public class PlanServiceImpl
extends AbstractService
implements PlanService {
    private static final List<PlanSecurityEntity> DEFAULT_SECURITY_LIST = Collections.unmodifiableList(Arrays.asList(new PlanSecurityEntity("mtls", "mTLS", "mtls"), new PlanSecurityEntity("oauth2", "OAuth2", "oauth2"), new PlanSecurityEntity("jwt", "JWT", "'jwt'"), new PlanSecurityEntity("api_key", "API Key", "api-key"), new PlanSecurityEntity("key_less", "Keyless (public)", "")));
    private final Logger logger = LoggerFactory.getLogger(PlanServiceImpl.class);
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private PlanSearchService planSearchService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private CloseSubscriptionDomainService closeSubscriptionDomainService;
    @Autowired
    private PageService pageService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private SynchronizationService synchronizationService;
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private PlanMapper planMapper;
    @Autowired
    private GenericPlanMapper genericPlanMapper;
    @Autowired
    private FlowService flowService;
    @Autowired
    private FlowCrudService flowCrudService;
    @Autowired
    private TagsValidationService tagsValidationService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private FlowValidationService flowValidationService;
    @Autowired
    private PathParametersValidationService pathParametersValidationService;
    @Autowired
    private GroupService groupService;

    @Override
    public PlanEntity findById(ExecutionContext executionContext, String planId) {
        return (PlanEntity)this.planSearchService.findById(executionContext, planId);
    }

    @Override
    public Set<PlanEntity> findByApi(ExecutionContext executionContext, String api) {
        return this.planSearchService.findByApi(executionContext, api).stream().map(PlanEntity.class::cast).collect(Collectors.toSet());
    }

    @Override
    public Set<NativePlanEntity> findNativePlansByApi(ExecutionContext executionContext, String api) {
        return this.planSearchService.findByApi(executionContext, api).stream().map(NativePlanEntity.class::cast).collect(Collectors.toSet());
    }

    private PlanEntity create(ExecutionContext executionContext, NewPlanEntity newPlan, boolean validatePathParams) {
        try {
            this.logger.debug("Create a new plan {} for API {}", (Object)newPlan.getName(), (Object)newPlan.getApiId());
            if (Optional.ofNullable(newPlan.getMode()).orElse(PlanMode.STANDARD) == PlanMode.STANDARD) {
                if (newPlan.getSecurity() == null) {
                    throw new PlanInvalidException("Security type is required for plan with 'STANDARD' mode");
                }
                this.assertPlanSecurityIsAllowed(executionContext, newPlan.getSecurity().getType());
                this.validatePlanSecurity(newPlan.getSecurity().getType(), newPlan.getSecurity().getConfiguration());
            } else if (newPlan.getSecurity() != null) {
                throw new PlanInvalidException("Security type is forbidden for plan with 'Push' mode");
            }
            Api api = (Api)this.apiRepository.findById((Object)newPlan.getApiId()).orElseThrow(() -> new ApiNotFoundException(newPlan.getApiId()));
            newPlan.setFlows(this.flowValidationService.validateAndSanitize(api.getType(), newPlan.getFlows()));
            if (api.getApiLifecycleState() == ApiLifecycleState.DEPRECATED) {
                throw new ApiDeprecatedException(api.getName());
            }
            this.validateTags(newPlan.getTags(), api);
            if (validatePathParams) {
                this.validatePathParameters(api, newPlan.getFlows());
            }
            String id = newPlan.getId() != null && UUID.fromString(newPlan.getId()) != null ? newPlan.getId() : UuidString.generateRandom();
            newPlan.setId(id);
            Plan plan = this.planMapper.toRepository(newPlan, api);
            plan.setEnvironmentId(executionContext.getEnvironmentId());
            plan = (Plan)this.planRepository.create((Object)plan);
            this.flowCrudService.savePlanFlows(plan.getId(), newPlan.getFlows());
            this.auditService.createApiAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId())).event((Audit.AuditEvent)Plan.AuditEvent.PLAN_CREATED).createdAt(plan.getCreatedAt()).oldValue(null).newValue(plan).build(), newPlan.getApiId());
            return this.mapToEntity(plan);
        }
        catch (TechnicalException ex) {
            String errorMsg = String.format("An error occurs while trying to create a plan %s for API %s", newPlan.getName(), newPlan.getApiId());
            this.logger.error(errorMsg, (Throwable)ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
    }

    private void validatePathParameters(Api api, List<Flow> newPlanFlows) throws TechnicalException {
        Set plans = this.planRepository.findByApi(api.getId());
        Stream<Flow> apiFlows = this.flowService.findByReference(FlowReferenceType.API, api.getId()).stream();
        Stream<Flow> planFlows = plans.stream().map(plan -> this.flowService.findByReference(FlowReferenceType.PLAN, plan.getId())).flatMap(Collection::stream);
        planFlows = Stream.concat(planFlows, newPlanFlows.stream());
        this.pathParametersValidationService.validate(api.getType(), apiFlows, planFlows);
    }

    private void validateTags(Set<String> tags, Api api) {
        this.tagsValidationService.validatePlanTagsAgainstApiTags(tags, api);
    }

    @Override
    public PlanEntity createOrUpdatePlan(ExecutionContext executionContext, PlanEntity planEntity) {
        PlanEntity resultPlanEntity;
        try {
            if (planEntity.getId() == null) {
                resultPlanEntity = this.create(executionContext, this.planMapper.toNewPlanEntity(planEntity), false);
            } else {
                this.planSearchService.findById(executionContext, planEntity.getId());
                resultPlanEntity = this.update(executionContext, this.planMapper.toUpdatePlanEntity(planEntity));
            }
        }
        catch (PlanNotFoundException npe) {
            resultPlanEntity = this.create(executionContext, this.planMapper.toNewPlanEntity(planEntity), false);
        }
        return resultPlanEntity;
    }

    private PlanEntity update(ExecutionContext executionContext, UpdatePlanEntity updatePlan) {
        try {
            this.logger.debug("Update plan {}", (Object)updatePlan.getName());
            Plan oldPlan = (Plan)this.planRepository.findById((Object)updatePlan.getId()).orElseThrow(() -> new PlanNotFoundException(updatePlan.getId()));
            if (Optional.ofNullable(oldPlan.getMode()).orElse(Plan.PlanMode.STANDARD) == Plan.PlanMode.STANDARD) {
                this.assertPlanSecurityIsAllowed(executionContext, PlanSecurityType.valueOf((String)oldPlan.getSecurity().name()).getLabel());
                this.validatePlanSecurity(PlanSecurityType.valueOf((String)oldPlan.getSecurity().name()).getLabel(), updatePlan.getSecurity().getConfiguration());
            }
            if (updatePlan.getFlows() == null) {
                throw new PlanFlowRequiredException(updatePlan.getId());
            }
            Plan newPlan = new Plan();
            newPlan.setDefinitionVersion(oldPlan.getDefinitionVersion());
            newPlan.setId(oldPlan.getId());
            newPlan.setDefinitionVersion(oldPlan.getDefinitionVersion());
            newPlan.setSecurity(oldPlan.getSecurity());
            newPlan.setType(oldPlan.getType());
            newPlan.setStatus(oldPlan.getStatus());
            newPlan.setOrder(oldPlan.getOrder());
            newPlan.setApi(oldPlan.getApi());
            newPlan.setCreatedAt(oldPlan.getCreatedAt());
            newPlan.setPublishedAt(oldPlan.getPublishedAt());
            newPlan.setClosedAt(oldPlan.getClosedAt());
            newPlan.setMode(oldPlan.getMode());
            newPlan.setApiType(oldPlan.getApiType());
            if (oldPlan.getNeedRedeployAt() == null) {
                newPlan.setNeedRedeployAt(oldPlan.getUpdatedAt());
            } else {
                newPlan.setNeedRedeployAt(oldPlan.getNeedRedeployAt());
            }
            newPlan.setName(updatePlan.getName());
            newPlan.setCrossId(updatePlan.getCrossId() != null ? updatePlan.getCrossId() : oldPlan.getCrossId());
            newPlan.setDescription(updatePlan.getDescription());
            newPlan.setUpdatedAt(new Date());
            if (updatePlan.getSecurity() != null) {
                newPlan.setSecurityDefinition(updatePlan.getSecurity().getConfiguration());
            } else {
                newPlan.setSecurityDefinition(null);
            }
            newPlan.setCommentRequired(updatePlan.isCommentRequired());
            newPlan.setCommentMessage(updatePlan.getCommentMessage());
            newPlan.setTags(updatePlan.getTags());
            newPlan.setSelectionRule(updatePlan.getSelectionRule());
            newPlan.setGeneralConditions(updatePlan.getGeneralConditions());
            if (Plan.Status.PUBLISHED.equals((Object)newPlan.getStatus()) || Plan.Status.DEPRECATED.equals((Object)newPlan.getStatus())) {
                this.checkStatusOfGeneralConditions(newPlan);
            }
            this.validateExcludedGroups(updatePlan.getExcludedGroups(), executionContext.getEnvironmentId());
            newPlan.setExcludedGroups(updatePlan.getExcludedGroups());
            if (newPlan.getSecurity() == Plan.PlanSecurityType.KEY_LESS) {
                newPlan.setValidation(Plan.PlanValidationType.AUTO);
            } else {
                newPlan.setValidation(Plan.PlanValidationType.valueOf((String)updatePlan.getValidation().name()));
            }
            newPlan.setCharacteristics(updatePlan.getCharacteristics());
            String apiId = newPlan.getApi();
            Api api = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            this.validateTags(newPlan.getTags(), api);
            updatePlan.setFlows(this.flowValidationService.validateAndSanitize(api.getType(), updatePlan.getFlows()));
            if (newPlan.getOrder() != updatePlan.getOrder()) {
                newPlan.setOrder(updatePlan.getOrder());
                this.reorderAndSavePlans(newPlan);
                return null;
            }
            PlanEntity oldPlanEntity = this.mapToEntity(oldPlan);
            this.flowCrudService.savePlanFlows(updatePlan.getId(), updatePlan.getFlows());
            PlanEntity newPlanEntity = this.mapToEntity(newPlan);
            if (!this.synchronizationService.checkSynchronization(PlanEntity.class, oldPlanEntity, newPlanEntity) || !this.synchronizationService.checkSynchronization(BasePlanEntity.class, oldPlanEntity, newPlanEntity)) {
                newPlan.setNeedRedeployAt(newPlan.getUpdatedAt());
            }
            newPlan = (Plan)this.planRepository.update((Object)newPlan);
            this.auditService.createApiAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.PLAN, newPlan.getId())).event((Audit.AuditEvent)Plan.AuditEvent.PLAN_UPDATED).createdAt(newPlan.getUpdatedAt()).oldValue(oldPlan).newValue(newPlan).build(), apiId);
            return this.mapToEntity(newPlan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)updatePlan.getName(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update plan %s", updatePlan.getName()), ex);
        }
    }

    private void validateExcludedGroups(List<String> excludedGroups, String environmentId) throws TechnicalException {
        Set envGroupsIds = this.groupService.findAllByEnvironment(environmentId).stream().map(Group::getId).collect(Collectors.toSet());
        if (excludedGroups != null && !excludedGroups.isEmpty()) {
            excludedGroups.forEach(excludedGroupId -> {
                if (!envGroupsIds.contains(excludedGroupId)) {
                    throw new GroupNotFoundException((String)excludedGroupId);
                }
            });
        }
    }

    private void validatePathParameters(Api api, UpdatePlanEntity updatePlan) throws TechnicalException {
        Set plans = this.planRepository.findByApi(api.getId());
        Stream<Flow> apiFlows = this.flowService.findByReference(FlowReferenceType.API, api.getId()).stream();
        Stream<Flow> planFlows = plans.stream().map(plan -> {
            if (plan.getId().equals(updatePlan.getId())) {
                return updatePlan.getFlows();
            }
            return this.flowService.findByReference(FlowReferenceType.PLAN, plan.getId());
        }).flatMap(Collection::stream);
        this.pathParametersValidationService.validate(api.getType(), apiFlows, planFlows);
    }

    private void checkStatusOfGeneralConditions(Plan plan) {
        PageEntity generalConditions;
        if (plan.getGeneralConditions() != null && !plan.getGeneralConditions().isEmpty() && !(generalConditions = this.pageService.findById(plan.getGeneralConditions())).isPublished()) {
            throw new PlanGeneralConditionStatusException(plan.getName());
        }
    }

    @Override
    public GenericPlanEntity close(ExecutionContext executionContext, String planId) {
        try {
            this.logger.debug("Close plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            plan.setStatus(Plan.Status.CLOSED);
            plan.setClosedAt(new Date());
            plan.setUpdatedAt(plan.getClosedAt());
            plan.setNeedRedeployAt(plan.getClosedAt());
            if (plan.getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                AuditInfo auditInfo = AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(this.getAuthenticatedUserAsAuditActor()).build();
                this.subscriptionService.findByPlan(executionContext, planId).forEach(subscription -> {
                    try {
                        this.closeSubscriptionDomainService.closeSubscription(subscription.getId(), auditInfo);
                    }
                    catch (SubscriptionNotClosableException subscriptionNotClosableException) {
                        // empty catch block
                    }
                });
            }
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId())).event((Audit.AuditEvent)Plan.AuditEvent.PLAN_CLOSED).createdAt(plan.getUpdatedAt()).oldValue(previousPlan).newValue(plan).build(), plan.getApi());
            this.reorderedAndSavePlansAfterRemove(plan);
            String apiId = plan.getApi();
            Api api = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            return this.genericPlanMapper.toGenericPlan(api, plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to close plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to close plan: %s", planId), ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String planId) {
        try {
            this.logger.debug("Delete plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            if (plan.getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                int subscriptions = this.subscriptionService.findByPlan(executionContext, planId).size();
                if ((plan.getStatus() == Plan.Status.PUBLISHED || plan.getStatus() == Plan.Status.DEPRECATED) && subscriptions > 0) {
                    throw new PlanWithSubscriptionsException(planId);
                }
            }
            if (plan.getApiType() == ApiType.NATIVE) {
                this.flowCrudService.saveNativePlanFlows(planId, null);
            } else {
                this.flowCrudService.savePlanFlows(planId, null);
            }
            this.planRepository.delete((Object)planId);
            this.auditService.createApiAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId())).event((Audit.AuditEvent)Plan.AuditEvent.PLAN_DELETED).createdAt(new Date()).oldValue(plan).newValue(null).build(), plan.getApi());
            this.reorderedAndSavePlansAfterRemove(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete plan: %s", planId), ex);
        }
    }

    @Override
    public GenericPlanEntity publish(ExecutionContext executionContext, String planId) {
        try {
            long count;
            this.logger.debug("Publish plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (plan.getStatus() == Plan.Status.PUBLISHED) {
                throw new PlanAlreadyPublishedException(planId);
            }
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            this.checkStatusOfGeneralConditions(plan);
            Set plans = this.planRepository.findByApi(plan.getApi());
            if (plan.getSecurity() == Plan.PlanSecurityType.KEY_LESS && (count = plans.stream().filter(plan1 -> plan1.getStatus() == Plan.Status.PUBLISHED || plan1.getStatus() == Plan.Status.DEPRECATED).filter(plan1 -> plan1.getSecurity() == Plan.PlanSecurityType.KEY_LESS).count()) > 0L) {
                throw new KeylessPlanAlreadyPublishedException(planId);
            }
            if (plan.getApiType() == ApiType.NATIVE) {
                this.validateNoConflictingAuthenticationForNativePlan(plan, plans);
            }
            plan.setStatus(Plan.Status.PUBLISHED);
            List orderedPublishedPlans = plans.stream().filter(plan1 -> Plan.Status.PUBLISHED.equals((Object)plan1.getStatus())).sorted(Comparator.comparingInt(Plan::getOrder)).collect(Collectors.toList());
            plan.setOrder(orderedPublishedPlans.isEmpty() ? 1 : ((Plan)orderedPublishedPlans.get(orderedPublishedPlans.size() - 1)).getOrder() + 1);
            plan.setPublishedAt(new Date());
            plan.setUpdatedAt(plan.getPublishedAt());
            plan.setNeedRedeployAt(plan.getPublishedAt());
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId())).event((Audit.AuditEvent)Plan.AuditEvent.PLAN_PUBLISHED).createdAt(plan.getUpdatedAt()).oldValue(previousPlan).newValue(plan).build(), plan.getApi());
            return this.mapToGenericEntity(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to publish plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to publish plan: %s", planId), ex);
        }
    }

    @Override
    public GenericPlanEntity deprecate(ExecutionContext executionContext, String planId) {
        return this.deprecate(executionContext, planId, false);
    }

    @Override
    public GenericPlanEntity deprecate(ExecutionContext executionContext, String planId, boolean allowStaging) {
        try {
            this.logger.debug("Deprecate plan {}", (Object)planId);
            Plan plan = (Plan)this.planRepository.findById((Object)planId).orElseThrow(() -> new PlanNotFoundException(planId));
            Plan previousPlan = new Plan(plan);
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (!allowStaging && plan.getStatus() == Plan.Status.STAGING) {
                throw new PlanNotYetPublishedException(planId);
            }
            plan.setStatus(Plan.Status.DEPRECATED);
            plan.setUpdatedAt(new Date());
            plan = (Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId())).event((Audit.AuditEvent)Plan.AuditEvent.PLAN_DEPRECATED).createdAt(plan.getUpdatedAt()).oldValue(previousPlan).newValue(plan).build(), plan.getApi());
            return this.mapToGenericEntity(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to deprecate plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to deprecate plan: %s", planId), ex);
        }
    }

    @Override
    public PlansConfigurationEntity getConfiguration() {
        PlansConfigurationEntity config = new PlansConfigurationEntity();
        config.setSecurity(DEFAULT_SECURITY_LIST);
        return config;
    }

    private void reorderAndSavePlans(Plan planToReorder) throws TechnicalException {
        Set plans = this.planRepository.findByApi(planToReorder.getApi());
        Plan[] plansToReorder = (Plan[])plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus()) && !Objects.equals(p.getId(), planToReorder.getId())).sorted(Comparator.comparingInt(Plan::getOrder)).toArray(Plan[]::new);
        if (planToReorder.getOrder() < 1) {
            planToReorder.setOrder(1);
        } else if (planToReorder.getOrder() > plansToReorder.length + 1) {
            planToReorder.setOrder(plansToReorder.length + 1);
        }
        try {
            for (int i = 0; i < plansToReorder.length; ++i) {
                int newOrder;
                int n = newOrder = i + 1 < planToReorder.getOrder() ? i + 1 : i + 2;
                if (plansToReorder[i].getOrder() == newOrder) continue;
                plansToReorder[i].setOrder(newOrder);
                this.planRepository.update((Object)plansToReorder[i]);
            }
            this.planRepository.update((Object)planToReorder);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)planToReorder.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update plan " + planToReorder.getId(), ex);
        }
    }

    private void reorderedAndSavePlansAfterRemove(Plan planRemoved) throws TechnicalException {
        Set plans = this.planRepository.findByApi(planRemoved.getApi());
        plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus())).sorted(Comparator.comparingInt(Plan::getOrder)).forEachOrdered(plan -> {
            try {
                if (plan.getOrder() > planRemoved.getOrder()) {
                    this.planRepository.updateOrder(plan.getId(), plan.getOrder() - 1);
                }
            }
            catch (TechnicalException ex) {
                this.logger.error("An error occurs while trying to reorder plan {}", (Object)plan.getId(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update plan " + plan.getId(), ex);
            }
        });
    }

    private void validateNoConflictingAuthenticationForNativePlan(Plan nativePlanToPublish, Set<Plan> apiPlans) {
        boolean planToPublishIsKeyless = nativePlanToPublish.getSecurity() == Plan.PlanSecurityType.KEY_LESS;
        long conflictingPublishedPlansCount = apiPlans.stream().filter(existingPlan -> existingPlan.getStatus() == Plan.Status.PUBLISHED).filter(existingPlan -> planToPublishIsKeyless ? existingPlan.getSecurity() != Plan.PlanSecurityType.KEY_LESS : existingPlan.getSecurity() == Plan.PlanSecurityType.KEY_LESS).count();
        if (conflictingPublishedPlansCount > 0L) {
            throw new NativePlanAuthenticationConflictException(planToPublishIsKeyless);
        }
    }

    private PlanEntity mapToEntity(Plan plan) {
        List<Flow> flows = this.flowService.findByReference(FlowReferenceType.PLAN, plan.getId());
        return this.planMapper.toEntity(plan, flows);
    }

    private GenericPlanEntity mapToGenericEntity(Plan plan) {
        if (plan.getApiType() == ApiType.NATIVE) {
            List<NativeFlow> flows = this.flowCrudService.getNativePlanFlows(plan.getId());
            return this.planMapper.toNativeEntity(plan, flows);
        }
        return this.mapToEntity(plan);
    }

    private void assertPlanSecurityIsAllowed(ExecutionContext executionContext, String securityType) {
        Key securityKey;
        PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)securityType);
        switch (planSecurityType) {
            case API_KEY: {
                securityKey = Key.PLAN_SECURITY_APIKEY_ENABLED;
                break;
            }
            case OAUTH2: {
                securityKey = Key.PLAN_SECURITY_OAUTH2_ENABLED;
                break;
            }
            case JWT: {
                securityKey = Key.PLAN_SECURITY_JWT_ENABLED;
                break;
            }
            case KEY_LESS: {
                securityKey = Key.PLAN_SECURITY_KEYLESS_ENABLED;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.parameterService.findAsBoolean(executionContext, securityKey, ParameterReferenceType.ENVIRONMENT)) {
            throw new UnauthorizedPlanSecurityTypeException(io.gravitee.rest.api.model.PlanSecurityType.valueOf((String)planSecurityType.name()));
        }
    }

    @Override
    public boolean anyPlanMismatchWithApi(List<String> planIds, String apiId) {
        try {
            return this.planRepository.findByIdIn(planIds).stream().map(Plan::getApi).filter(Objects::nonNull).anyMatch(id -> !id.equals(apiId));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred checking plans ownership", e);
        }
    }

    @Override
    public Map<String, Object> findByIdAsMap(String id) throws TechnicalException {
        Plan plan = (Plan)this.planRepository.findById((Object)id).orElseThrow(() -> new PlanNotFoundException(id));
        return (Map)this.objectMapper.convertValue((Object)plan, Map.class);
    }

    private void validatePlanSecurity(String type, String configuration) {
        this.policyService.validatePolicyConfiguration(type, configuration);
    }
}

