/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.event;

import com.google.common.util.concurrent.AtomicLongMap;
import io.gravitee.apim.core.event.crud_service.EventCrudService;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.infra.adapter.EventAdapter;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Flowable;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class EventCrudServiceLegacyWrapper
implements EventCrudService {
    private static final Logger logger = LoggerFactory.getLogger(EventCrudServiceLegacyWrapper.class);
    private final EventService eventService;
    private final EventRepository eventRepository;

    public EventCrudServiceLegacyWrapper(EventService eventService, @Lazy EventRepository eventRepository) {
        this.eventService = eventService;
        this.eventRepository = eventRepository;
    }

    @Override
    public Event createEvent(String organizationId, String environmentId, Set<String> environmentIds, EventType eventType, Object content, Map<Event.EventProperties, String> properties) {
        return EventAdapter.INSTANCE.fromEntity(this.eventService.createEvent(new ExecutionContext(organizationId, environmentId), environmentIds, organizationId, eventType, content, EventAdapter.INSTANCE.toStringEventPropertiesMap(properties)));
    }

    @Override
    public Event get(String organizationId, String environmentId, String eventId) {
        return EventAdapter.INSTANCE.fromEntity(this.eventService.findById(new ExecutionContext(organizationId, environmentId), eventId));
    }

    @Override
    public void cleanupEvents(String environmentId, int nbEventsToKeep, Duration timeToLive) {
        AtomicLongMap counters = AtomicLongMap.create();
        logger.info("Starting cleanup for environment: {} (keep {} events per type, max duration: {}s)", new Object[]{environmentId, nbEventsToKeep, timeToLive.toSeconds()});
        long startTime = System.currentTimeMillis();
        AtomicLong processedCount = new AtomicLong(0L);
        AtomicLong deletedCount = new AtomicLong(0L);
        AtomicLong skippedCount = new AtomicLong(0L);
        try {
            Flowable.fromStream((Stream)this.eventRepository.findEventsToClean(environmentId)).filter(eventToClean -> {
                EventRepository.EventToCleanGroup group;
                long currentProcessed = processedCount.incrementAndGet();
                if (currentProcessed % 1000L == 0L) {
                    logger.info("Processed {} events, deleted {} events, skipped {} events", new Object[]{currentProcessed, deletedCount.get(), skippedCount.get()});
                }
                if ((group = eventToClean.group()) == null) {
                    skippedCount.incrementAndGet();
                    return false;
                }
                long currentGroupCount = counters.get((Object)group);
                if (currentGroupCount >= (long)nbEventsToKeep) {
                    deletedCount.incrementAndGet();
                    return true;
                }
                counters.incrementAndGet((Object)group);
                skippedCount.incrementAndGet();
                return false;
            }).map(EventRepository.EventToClean::id).buffer(20).takeUntil((Publisher)Flowable.timer((long)timeToLive.toSeconds(), (TimeUnit)TimeUnit.SECONDS)).blockingForEach(arg_0 -> ((EventRepository)this.eventRepository).delete(arg_0));
            long duration = System.currentTimeMillis() - startTime;
            logger.info("Cleanup completed for environment: {}. Processed: {} events, Deleted: {} events, Skipped: {} events, Duration: {}ms", new Object[]{environmentId, processedCount.get(), deletedCount.get(), skippedCount.get(), duration});
        }
        catch (Exception e) {
            long duration = System.currentTimeMillis() - startTime;
            logger.error("Cleanup failed for environment: {} after {}ms. Processed: {} events, Deleted: {} events, Skipped: {} events", new Object[]{environmentId, duration, processedCount.get(), deletedCount.get(), skippedCount.get(), e});
            throw e;
        }
    }
}

