/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.model.mapper.V4toV2RollbackOperator;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.event.query_service.EventQueryService;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.ClosePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.lang.runtime.SwitchBootstraps;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@UseCase
public class RollbackApiUseCase {
    private static final V4toV2RollbackOperator ROLLBACK_OPERATOR = new V4toV2RollbackOperator();
    private static final String ROLLBACK = "rollback";
    private static final String CLOSE = "close";
    private static final String REOPEN = "reopen";
    private final EventQueryService eventQueryService;
    private final ApiCrudService apiCrudService;
    private final UpdateApiDomainService updateApiDomainService;
    private final PlanQueryService planQueryService;
    private final CreatePlanDomainService createPlanDomainService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final ClosePlanDomainService closePlanDomainService;
    private final PlanCrudService planCrudService;
    private final AuditDomainService auditService;
    private final FlowCrudService flowCrudService;
    private final ApiIndexerDomainService apiIndexerDomainService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ApiStateDomainService apiStateService;

    public void execute(Input input) {
        io.gravitee.apim.core.api.model.Api api = this.eventQueryService.findApiFromPublishApiEvent(input.eventId).orElseThrow(() -> new IllegalStateException("Cannot rollback an event that is not a publish event!"));
        DefinitionVersion definitionVersion = api.getDefinitionVersion();
        int n = 0;
        io.gravitee.apim.core.api.model.Api apiUpdated = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"V4", "V2", "FEDERATED_AGENT", "FEDERATED", "V1"}, (DefinitionVersion)definitionVersion, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Api apiDefinition = api.getApiDefinitionHttpV4();
                io.gravitee.apim.core.api.model.Api toRollback = this.apiCrudService.get(apiDefinition.getId());
                io.gravitee.apim.core.api.model.Api rollbackedApi = toRollback.rollbackTo(apiDefinition);
                rollbackedApi.setDescription(api.getDescription());
                io.gravitee.apim.core.api.model.Api apiUpdatedV4 = this.updateApiDomainService.updateV4(rollbackedApi, input.auditInfo);
                this.rollbackPlansV4(apiDefinition.getPlans(), apiUpdatedV4, input.auditInfo);
                yield apiUpdatedV4;
            }
            case 1 -> {
                Api apiDefinition = api.getApiDefinition();
                io.gravitee.apim.core.api.model.Api toRollback = this.apiCrudService.get(api.getId());
                if (toRollback.getDefinitionVersion() != DefinitionVersion.V4) {
                    throw new IllegalStateException("The migration is only built for rollback migration from V2 to V4.");
                }
                if (apiDefinition.getServices().getDynamicPropertyService() != null && apiDefinition.getServices().getDynamicPropertyService().isEnabled()) {
                    this.apiStateService.stopV4DynamicProperties(api.getId());
                }
                io.gravitee.apim.core.api.model.Api rollbackedApi = ROLLBACK_OPERATOR.rollback(toRollback, (io.gravitee.definition.model.Api)apiDefinition);
                PrimaryOwnerEntity apiPrimaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(input.auditInfo().organizationId(), api.getId());
                ApiIndexerDomainService.Context indexerContext = new ApiIndexerDomainService.Context(input.auditInfo(), false);
                this.apiIndexerDomainService.delete(indexerContext, toRollback);
                this.apiIndexerDomainService.index(indexerContext, rollbackedApi, apiPrimaryOwner);
                io.gravitee.apim.core.api.model.Api apiUpdatedV2 = this.apiCrudService.update(rollbackedApi);
                Plans plans = this.rollbackPlansV2(apiDefinition.getPlans(), apiUpdatedV2, input.auditInfo);
                this.flowCrudService.saveApiFlowsV2(apiDefinition.getId(), apiDefinition.getFlows());
                for (io.gravitee.definition.model.Plan plan : apiDefinition.getPlans()) {
                    this.flowCrudService.savePlanFlowsV2(plan.getId(), plan.getFlows());
                }
                for (String planId : plans.closedPlans()) {
                    this.flowCrudService.savePlanFlowsV2(planId, List.of());
                }
                if (apiDefinition.getServices().getDynamicPropertyService() != null && apiDefinition.getServices().getDynamicPropertyService().isEnabled()) {
                    this.apiStateService.startV2DynamicProperties(rollbackedApi.getId());
                }
                yield apiUpdatedV2;
            }
            case 2 -> throw new IllegalStateException("Cannot rollback a federated Agent");
            case 3 -> throw new IllegalStateException("Cannot rollback a federated API");
            case 4 -> throw new IllegalStateException("Cannot rollback an API that is not a V4 API");
            case -1 -> throw new IllegalStateException("Cannot determine API definition version from event" + input.eventId());
        };
        this.createAuditLog(input.auditInfo, apiUpdated.getId(), apiUpdated.getUpdatedAt());
    }

    private void rollbackPlansV4(List<io.gravitee.definition.model.v4.plan.Plan> apiDefinitionPlans, io.gravitee.apim.core.api.model.Api api, AuditInfo auditInfo) {
        if (apiDefinitionPlans == null) {
            return;
        }
        HashSet<Plan> plansToAdd = new HashSet<Plan>();
        HashSet<Plan> plansToUpdate = new HashSet<Plan>();
        Map existingPlans = this.planQueryService.findAllByApiId(api.getId()).stream().collect(Collectors.toMap(Plan::getId, Function.identity()));
        for (io.gravitee.definition.model.v4.plan.Plan apiDefinitionPlan : apiDefinitionPlans) {
            Plan existingPlan2;
            Plan plan = existingPlan2 = apiDefinitionPlan.getId() != null ? (Plan)existingPlans.get(apiDefinitionPlan.getId()) : null;
            if (existingPlan2 == null) {
                plansToAdd.add(new Plan(api.getId(), apiDefinitionPlan));
                continue;
            }
            plansToUpdate.add(existingPlan2.rollbackTo(apiDefinitionPlan));
        }
        plansToAdd.forEach(planToAdd -> this.createPlanDomainService.create((Plan)planToAdd, planToAdd.getPlanDefinitionHttpV4().getFlows() == null ? List.of() : planToAdd.getPlanDefinitionHttpV4().getFlows(), api, auditInfo));
        Map existingPlanStatuses = Map.of();
        plansToUpdate.forEach(planToUpdate -> this.updatePlanDomainService.update((Plan)planToUpdate, planToUpdate.getPlanDefinitionHttpV4().getFlows() == null ? List.of() : planToUpdate.getPlanDefinitionHttpV4().getFlows(), existingPlanStatuses, api, auditInfo));
        existingPlans.values().stream().filter(existingPlan -> existingPlan.getPlanStatus() != PlanStatus.CLOSED && !plansToUpdate.stream().map(Plan::getId).collect(Collectors.toSet()).contains(existingPlan.getId())).forEach(existingPlan -> this.closePlanDomainService.close(existingPlan.getId(), auditInfo));
    }

    private void createAuditLog(AuditInfo auditInfo, String apiId, ZonedDateTime auditCreatedAt) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(apiId).event(ApiAuditEvent.API_ROLLBACKED).actor(auditInfo.actor()).createdAt(auditCreatedAt).properties(Collections.emptyMap()).build());
    }

    private Plans rollbackPlansV2(List<io.gravitee.definition.model.Plan> apiDefinitionPlans, io.gravitee.apim.core.api.model.Api api, AuditInfo auditInfo) {
        if (apiDefinitionPlans == null) {
            return new Plans(List.of(), List.of());
        }
        Map plansToUpdateById = CollectionUtils.stream(apiDefinitionPlans).collect(Collectors.toMap(io.gravitee.definition.model.Plan::getId, Function.identity()));
        Map<String, List<Plan>> existingPlansMustBeRollbackOrClose = this.planQueryService.findAllByApiId(api.getId()).stream().collect(Collectors.groupingBy(currentPlan -> {
            io.gravitee.definition.model.Plan targetOfRollback = (io.gravitee.definition.model.Plan)plansToUpdateById.get(currentPlan.getId());
            if (targetOfRollback == null) {
                return CLOSE;
            }
            if (PlanStatus.valueOf((String)targetOfRollback.getStatus()) != PlanStatus.CLOSED && currentPlan.getPlanStatus() == PlanStatus.CLOSED) {
                currentPlan.setPlanStatus(PlanStatus.valueOf((String)targetOfRollback.getStatus()));
                return REOPEN;
            }
            return ROLLBACK;
        }));
        if (Stream.of(ROLLBACK, REOPEN).mapToInt(c -> CollectionUtils.size((Collection)existingPlansMustBeRollbackOrClose.get(c))).sum() < apiDefinitionPlans.size()) {
            throw new IllegalStateException("Cannot rollback plans because some plans have been removed");
        }
        existingPlansMustBeRollbackOrClose.getOrDefault(CLOSE, List.of()).forEach(plan -> {
            if (plan.getPlanStatus() != PlanStatus.CLOSED) {
                this.closePlanDomainService.close(plan.getId(), auditInfo);
            }
        });
        existingPlansMustBeRollbackOrClose.getOrDefault(ROLLBACK, List.of()).forEach(planToUpdate -> {
            io.gravitee.definition.model.Plan plan = (io.gravitee.definition.model.Plan)plansToUpdateById.get(planToUpdate.getId());
            this.planCrudService.update(ROLLBACK_OPERATOR.rollback((Plan)planToUpdate, plan));
        });
        existingPlansMustBeRollbackOrClose.getOrDefault(REOPEN, List.of()).forEach(plan -> this.planCrudService.update((Plan)plan));
        List<String> opens = Stream.concat(existingPlansMustBeRollbackOrClose.getOrDefault(ROLLBACK, List.of()).stream(), existingPlansMustBeRollbackOrClose.getOrDefault(REOPEN, List.of()).stream()).map(Plan::getId).toList();
        List<String> closes = existingPlansMustBeRollbackOrClose.getOrDefault(CLOSE, List.of()).stream().map(Plan::getId).toList();
        return new Plans(opens, closes);
    }

    @Generated
    public RollbackApiUseCase(EventQueryService eventQueryService, ApiCrudService apiCrudService, UpdateApiDomainService updateApiDomainService, PlanQueryService planQueryService, CreatePlanDomainService createPlanDomainService, UpdatePlanDomainService updatePlanDomainService, ClosePlanDomainService closePlanDomainService, PlanCrudService planCrudService, AuditDomainService auditService, FlowCrudService flowCrudService, ApiIndexerDomainService apiIndexerDomainService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ApiStateDomainService apiStateService) {
        this.eventQueryService = eventQueryService;
        this.apiCrudService = apiCrudService;
        this.updateApiDomainService = updateApiDomainService;
        this.planQueryService = planQueryService;
        this.createPlanDomainService = createPlanDomainService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.closePlanDomainService = closePlanDomainService;
        this.planCrudService = planCrudService;
        this.auditService = auditService;
        this.flowCrudService = flowCrudService;
        this.apiIndexerDomainService = apiIndexerDomainService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.apiStateService = apiStateService;
    }

    public record Input(String eventId, AuditInfo auditInfo) {
    }

    private record Plans(Collection<String> openPlans, Collection<String> closedPlans) {
    }
}

