/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.exception.ApiInvalidTypeException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.NewNativeApi;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.definition.model.v4.ApiType;

@UseCase
public class CreateNativeApiUseCase {
    private final ValidateApiDomainService validateApiDomainService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final CreateApiDomainService createApiDomainService;

    public CreateNativeApiUseCase(ValidateApiDomainService validateApiDomainService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, CreateApiDomainService createApiDomainService) {
        this.validateApiDomainService = validateApiDomainService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.createApiDomainService = createApiDomainService;
    }

    public Output execute(Input input) {
        if (input.newApi == null || input.newApi.getType() != ApiType.NATIVE) {
            throw new ApiInvalidTypeException(ApiType.NATIVE);
        }
        AuditInfo auditInfo = input.auditInfo;
        PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(auditInfo.organizationId(), auditInfo.environmentId(), auditInfo.actor().userId());
        ApiWithFlows created = this.createApiDomainService.create(ApiModelFactory.fromNewNativeApi(input.newApi, auditInfo.environmentId()), primaryOwner, auditInfo, api -> this.validateApiDomainService.validateAndSanitizeForCreation((Api)api, primaryOwner, auditInfo.environmentId(), auditInfo.organizationId()), ApiIndexerDomainService.oneShotIndexation(auditInfo));
        return new Output(created);
    }

    public record Input(NewNativeApi newApi, AuditInfo auditInfo) {
    }

    public record Output(ApiWithFlows api) {
    }
}

