/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.ApiAdapterDecorator;
import io.gravitee.apim.infra.adapter.PrimaryOwnerAdapter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.federation.FederatedAgent;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.federation.FederatedApiAgentEntity;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativeApiEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.CategoryMapper;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.PlanService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="ApiMapperV4")
public class ApiMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMapper.class);
    private final ObjectMapper objectMapper;
    private final PlanService planService;
    private final FlowService flowService;
    private final ParameterService parameterService;
    private final WorkflowService workflowService;
    private final CategoryMapper categoryMapper;

    public ApiMapper(ObjectMapper objectMapper, @Lazy PlanService planService, @Lazy FlowService flowService, ParameterService parameterService, WorkflowService workflowService, CategoryMapper categoryMapper) {
        this.objectMapper = objectMapper;
        this.planService = planService;
        this.flowService = flowService;
        this.parameterService = parameterService;
        this.workflowService = workflowService;
        this.categoryMapper = categoryMapper;
    }

    public ApiEntity toEntity(io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner) {
        ApiLifecycleState lifecycleState;
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setCrossId(api.getCrossId());
        apiEntity.setHrid(api.getHrid());
        apiEntity.setName(api.getName());
        apiEntity.setApiVersion(api.getVersion());
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        apiEntity.setDescription(api.getDescription());
        if (api.getDefinition() != null) {
            try {
                Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                apiEntity.setDefinitionVersion(apiDefinition.getDefinitionVersion());
                apiEntity.setAnalytics(apiDefinition.getAnalytics());
                apiEntity.setFailover(apiDefinition.getFailover());
                apiEntity.setListeners(apiDefinition.getListeners());
                apiEntity.setEndpointGroups(apiDefinition.getEndpointGroups());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                apiEntity.setFlowExecution(apiDefinition.getFlowExecution());
                apiEntity.setFlows(apiDefinition.getFlows());
                apiEntity.setResponseTemplates(apiDefinition.getResponseTemplates());
            }
            catch (IOException ioe) {
                log.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        if (api.getType() != null) {
            apiEntity.setType(ApiType.fromLabel((String)api.getType().getLabel()));
        }
        apiEntity.setGroups(api.getGroups());
        apiEntity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
        apiEntity.setReferenceType(ReferenceContext.Type.ENVIRONMENT.name());
        apiEntity.setReferenceId(api.getEnvironmentId());
        apiEntity.setCategories(this.categoryMapper.toCategoryKey(api.getEnvironmentId(), api.getCategories()));
        apiEntity.setPicture(api.getPicture());
        apiEntity.setBackground(api.getBackground());
        apiEntity.setLabels(api.getLabels());
        LifecycleState state = api.getLifecycleState();
        if (state != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)state.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if ((lifecycleState = api.getApiLifecycleState()) != null) {
            apiEntity.setLifecycleState(io.gravitee.rest.api.model.api.ApiLifecycleState.valueOf((String)lifecycleState.name()));
        }
        apiEntity.setOriginContext(ApiAdapterDecorator.toOriginContext(api));
        apiEntity.setPrimaryOwner(primaryOwner);
        return apiEntity;
    }

    public NativeApiEntity toNativeEntity(io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner) {
        ApiLifecycleState lifecycleState;
        NativeApiEntity apiEntity = new NativeApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setCrossId(api.getCrossId());
        apiEntity.setHrid(api.getHrid());
        apiEntity.setName(api.getName());
        apiEntity.setApiVersion(api.getVersion());
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        apiEntity.setDescription(api.getDescription());
        if (api.getDefinition() != null) {
            try {
                NativeApi apiDefinition = (NativeApi)this.objectMapper.readValue(api.getDefinition(), NativeApi.class);
                apiEntity.setDefinitionVersion(apiDefinition.getDefinitionVersion());
                apiEntity.setListeners(apiDefinition.getListeners());
                apiEntity.setEndpointGroups(apiDefinition.getEndpointGroups());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                apiEntity.setFlows(apiDefinition.getFlows());
            }
            catch (IOException ioe) {
                log.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        if (api.getType() != null) {
            apiEntity.setType(ApiType.fromLabel((String)api.getType().getLabel()));
        }
        apiEntity.setGroups(api.getGroups());
        apiEntity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
        apiEntity.setReferenceType(ReferenceContext.Type.ENVIRONMENT.name());
        apiEntity.setReferenceId(api.getEnvironmentId());
        apiEntity.setCategories(this.categoryMapper.toCategoryKey(api.getEnvironmentId(), api.getCategories()));
        apiEntity.setPicture(api.getPicture());
        apiEntity.setBackground(api.getBackground());
        apiEntity.setLabels(api.getLabels());
        LifecycleState state = api.getLifecycleState();
        if (state != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)state.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if ((lifecycleState = api.getApiLifecycleState()) != null) {
            apiEntity.setLifecycleState(io.gravitee.rest.api.model.api.ApiLifecycleState.valueOf((String)lifecycleState.name()));
        }
        apiEntity.setOriginContext(ApiAdapterDecorator.toOriginContext(api));
        apiEntity.setPrimaryOwner(primaryOwner);
        return apiEntity;
    }

    public FederatedApiEntity federatedToEntity(io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner) {
        api.setCategories(this.categoryMapper.toCategoryKey(api.getEnvironmentId(), api.getCategories()));
        return ApiAdapter.INSTANCE.toFederatedApiEntity(api, PrimaryOwnerAdapter.INSTANCE.fromRestEntity(primaryOwner));
    }

    public ApiEntity toEntity(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, boolean readDatabaseFlows) {
        return this.toEntity(executionContext, api, null, readDatabaseFlows);
    }

    public ApiEntity toEntity(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner, boolean readDatabaseFlows) {
        List<Workflow> workflows;
        ApiEntity apiEntity = this.toEntity(api, primaryOwner);
        Set<PlanEntity> plans = this.planService.findByApi(executionContext, api.getId());
        apiEntity.setPlans(plans);
        if (readDatabaseFlows) {
            List<Flow> flows = this.flowService.findByReference(FlowReferenceType.API, api.getId());
            apiEntity.setFlows(flows);
        }
        apiEntity.setCategories(this.categoryMapper.toCategoryKey(executionContext.getEnvironmentId(), api.getCategories()));
        if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, api.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT) && (workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, api.getId(), WorkflowType.REVIEW)) != null && !workflows.isEmpty()) {
            apiEntity.setWorkflowState(WorkflowState.valueOf((String)workflows.get(0).getState()));
        }
        return apiEntity;
    }

    public NativeApiEntity toNativeEntity(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner, boolean readDatabaseFlows) {
        List<Workflow> workflows;
        NativeApiEntity apiEntity = this.toNativeEntity(api, primaryOwner);
        Set<NativePlanEntity> plans = this.planService.findNativePlansByApi(executionContext, api.getId());
        apiEntity.setPlans(plans);
        if (readDatabaseFlows) {
            List<NativeFlow> flows = this.flowService.findNativeFlowByReference(FlowReferenceType.API, api.getId());
            apiEntity.setFlows(flows);
        }
        apiEntity.setCategories(this.categoryMapper.toCategoryKey(executionContext.getEnvironmentId(), api.getCategories()));
        if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, api.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT) && (workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, api.getId(), WorkflowType.REVIEW)) != null && !workflows.isEmpty()) {
            apiEntity.setWorkflowState(WorkflowState.valueOf((String)workflows.get(0).getState()));
        }
        return apiEntity;
    }

    public FederatedApiEntity federatedToEntity(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner) {
        api.setCategories(this.categoryMapper.toCategoryKey(executionContext.getEnvironmentId(), api.getCategories()));
        return ApiAdapter.INSTANCE.toFederatedApiEntity(api, PrimaryOwnerAdapter.INSTANCE.fromRestEntity(primaryOwner));
    }

    public FederatedApiAgentEntity federatedAgentToEntity(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner) {
        try {
            api.setCategories(this.categoryMapper.toCategoryKey(executionContext.getEnvironmentId(), api.getCategories()));
            FederatedAgent agent = (FederatedAgent)this.objectMapper.readValue(api.getDefinition(), FederatedAgent.class);
            OriginContext.Integration a2a = new OriginContext.Integration(api.getIntegrationId(), api.getIntegrationId(), "A2A");
            return ApiAdapter.INSTANCE.toFederatedAgentEntity(api, agent, PrimaryOwnerAdapter.INSTANCE.fromRestEntity(primaryOwner), a2a);
        }
        catch (JsonProcessingException e) {
            log.warn("Unable to parse api definition for agent {}", (Object)api.getId(), (Object)e);
            return null;
        }
    }

    public io.gravitee.repository.management.model.Api toRepository(ExecutionContext executionContext, NewApiEntity newApiEntity) {
        io.gravitee.repository.management.model.Api repoApi = new io.gravitee.repository.management.model.Api();
        String generatedApiId = UuidString.generateRandom();
        repoApi.setId(generatedApiId);
        repoApi.setEnvironmentId(executionContext.getEnvironmentId());
        repoApi.setCreatedAt(new Date());
        repoApi.setUpdatedAt(repoApi.getCreatedAt());
        repoApi.setApiLifecycleState(ApiLifecycleState.CREATED);
        repoApi.setLifecycleState(LifecycleState.STOPPED);
        repoApi.setVisibility(io.gravitee.repository.management.model.Visibility.PRIVATE);
        repoApi.setName(newApiEntity.getName().trim());
        repoApi.setVersion(newApiEntity.getApiVersion().trim());
        String description = newApiEntity.getDescription();
        if (description != null) {
            repoApi.setDescription(description.trim());
        }
        repoApi.setDefinitionVersion(newApiEntity.getDefinitionVersion());
        repoApi.setDefinition(this.toApiDefinition(generatedApiId, newApiEntity));
        repoApi.setType(newApiEntity.getType());
        repoApi.setGroups((Collection)newApiEntity.getGroups());
        return repoApi;
    }

    private String toApiDefinition(String apiId, NewApiEntity newApiEntity) {
        try {
            Api apiDefinition = new Api();
            apiDefinition.setId(apiId);
            apiDefinition.setName(newApiEntity.getName());
            apiDefinition.setType(newApiEntity.getType());
            apiDefinition.setDefinitionVersion(newApiEntity.getDefinitionVersion());
            apiDefinition.setApiVersion(newApiEntity.getApiVersion());
            apiDefinition.setTags(newApiEntity.getTags());
            apiDefinition.setListeners(newApiEntity.getListeners());
            apiDefinition.setEndpointGroups(newApiEntity.getEndpointGroups());
            apiDefinition.setAnalytics(newApiEntity.getAnalytics());
            apiDefinition.setFailover(newApiEntity.getFailover());
            apiDefinition.setFlowExecution(newApiEntity.getFlowExecution());
            apiDefinition.setFlows(newApiEntity.getFlows());
            return this.objectMapper.writeValueAsString((Object)apiDefinition);
        }
        catch (JsonProcessingException jse) {
            log.error("Unexpected error while generating API definition", (Throwable)jse);
            throw new TechnicalManagementException("An error occurs while trying to parse API definition " + String.valueOf((Object)jse));
        }
    }

    public io.gravitee.repository.management.model.Api toRepository(ExecutionContext executionContext, UpdateApiEntity updateApiEntity) {
        io.gravitee.repository.management.model.Api repoApi = new io.gravitee.repository.management.model.Api();
        String apiId = updateApiEntity.getId();
        repoApi.setId(apiId.trim());
        repoApi.setCrossId(updateApiEntity.getCrossId());
        repoApi.setHrid(updateApiEntity.getHrid());
        repoApi.setEnvironmentId(executionContext.getEnvironmentId());
        repoApi.setType(updateApiEntity.getType());
        repoApi.setUpdatedAt(new Date());
        if (updateApiEntity.getLifecycleState() != null) {
            repoApi.setApiLifecycleState(ApiLifecycleState.valueOf((String)updateApiEntity.getLifecycleState().name()));
        }
        if (updateApiEntity.getVisibility() != null) {
            repoApi.setVisibility(io.gravitee.repository.management.model.Visibility.valueOf((String)updateApiEntity.getVisibility().toString()));
        }
        repoApi.setName(updateApiEntity.getName().trim());
        repoApi.setVersion(updateApiEntity.getApiVersion().trim());
        String description = updateApiEntity.getDescription();
        if (description != null) {
            repoApi.setDescription(description.trim());
        }
        repoApi.setPicture(updateApiEntity.getPicture());
        repoApi.setBackground(updateApiEntity.getBackground());
        repoApi.setDefinitionVersion(updateApiEntity.getDefinitionVersion());
        repoApi.setDefinition(this.toApiDefinition(updateApiEntity));
        repoApi.setCategories(this.categoryMapper.toCategoryId(executionContext.getEnvironmentId(), updateApiEntity.getCategories()));
        if (updateApiEntity.getLabels() != null) {
            repoApi.setLabels(new ArrayList(new HashSet(updateApiEntity.getLabels())));
        }
        repoApi.setGroups((Collection)updateApiEntity.getGroups());
        repoApi.setDisableMembershipNotifications(updateApiEntity.isDisableMembershipNotifications());
        return repoApi;
    }

    private String toApiDefinition(UpdateApiEntity updateApiEntity) {
        try {
            Api apiDefinition = new Api();
            apiDefinition.setId(updateApiEntity.getId());
            apiDefinition.setName(updateApiEntity.getName());
            apiDefinition.setType(updateApiEntity.getType());
            apiDefinition.setApiVersion(updateApiEntity.getApiVersion());
            apiDefinition.setDefinitionVersion(updateApiEntity.getDefinitionVersion());
            apiDefinition.setTags(updateApiEntity.getTags());
            apiDefinition.setListeners(updateApiEntity.getListeners());
            apiDefinition.setEndpointGroups(updateApiEntity.getEndpointGroups());
            apiDefinition.setAnalytics(updateApiEntity.getAnalytics());
            apiDefinition.setFailover(updateApiEntity.getFailover());
            if (updateApiEntity.getProperties() != null) {
                apiDefinition.setProperties(updateApiEntity.getProperties().stream().map(propertyEntity -> new Property(propertyEntity.getKey(), propertyEntity.getValue(), propertyEntity.isEncrypted(), propertyEntity.isDynamic())).collect(Collectors.toList()));
            }
            apiDefinition.setResources(updateApiEntity.getResources());
            apiDefinition.setFlowExecution(updateApiEntity.getFlowExecution());
            apiDefinition.setFlows(updateApiEntity.getFlows());
            apiDefinition.setResponseTemplates(updateApiEntity.getResponseTemplates());
            apiDefinition.setServices(updateApiEntity.getServices());
            return this.objectMapper.writeValueAsString((Object)apiDefinition);
        }
        catch (JsonProcessingException jse) {
            log.error("Unexpected error while generating API definition", (Throwable)jse);
            throw new TechnicalManagementException("An error occurs while trying to parse API definition " + String.valueOf((Object)jse));
        }
    }

    public io.gravitee.repository.management.model.Api toRepository(ExecutionContext executionContext, ApiEntity apiEntity) {
        io.gravitee.repository.management.model.Api repoApi = new io.gravitee.repository.management.model.Api();
        if (apiEntity.getLifecycleState() != null) {
            repoApi.setApiLifecycleState(ApiLifecycleState.valueOf((String)apiEntity.getLifecycleState().name()));
        }
        repoApi.setBackground(apiEntity.getBackground());
        repoApi.setCategories(this.categoryMapper.toCategoryId(executionContext.getEnvironmentId(), apiEntity.getCategories()));
        repoApi.setCrossId(apiEntity.getCrossId());
        repoApi.setHrid(apiEntity.getHrid());
        repoApi.setCreatedAt(apiEntity.getCreatedAt());
        repoApi.setDefinition(this.toApiDefinition(apiEntity));
        repoApi.setDefinitionVersion(apiEntity.getDefinitionVersion());
        repoApi.setDeployedAt(apiEntity.getDeployedAt());
        repoApi.setDescription(apiEntity.getDescription());
        repoApi.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        repoApi.setEnvironmentId(executionContext.getEnvironmentId());
        repoApi.setGroups((Collection)apiEntity.getGroups());
        repoApi.setId(apiEntity.getId());
        if (apiEntity.getLabels() != null) {
            repoApi.setLabels(new ArrayList(new HashSet(apiEntity.getLabels())));
        }
        if (apiEntity.getState() != null) {
            repoApi.setLifecycleState(LifecycleState.valueOf((String)apiEntity.getState().name()));
        }
        repoApi.setOrigin(apiEntity.getOriginContext().name());
        OriginContext originContext = apiEntity.getOriginContext();
        if (originContext instanceof OriginContext.Kubernetes) {
            OriginContext.Kubernetes kube = (OriginContext.Kubernetes)originContext;
            repoApi.setMode(kube.mode().name().toLowerCase());
        } else {
            originContext = apiEntity.getOriginContext();
            if (originContext instanceof OriginContext.Integration) {
                OriginContext.Integration integration = (OriginContext.Integration)originContext;
                repoApi.setIntegrationId(integration.integrationId());
            }
        }
        repoApi.setName(apiEntity.getName());
        repoApi.setPicture(apiEntity.getPicture());
        repoApi.setType(apiEntity.getType());
        repoApi.setUpdatedAt(apiEntity.getUpdatedAt());
        if (apiEntity.getVisibility() != null) {
            repoApi.setVisibility(io.gravitee.repository.management.model.Visibility.valueOf((String)apiEntity.getVisibility().toString()));
        }
        repoApi.setVersion(apiEntity.getApiVersion());
        return repoApi;
    }

    private String toApiDefinition(ApiEntity apiEntity) {
        try {
            Api apiDefinition = new Api();
            apiDefinition.setId(apiEntity.getId());
            apiDefinition.setName(apiEntity.getName());
            apiDefinition.setType(apiEntity.getType());
            apiDefinition.setApiVersion(apiEntity.getApiVersion());
            apiDefinition.setDefinitionVersion(apiEntity.getDefinitionVersion());
            apiDefinition.setTags(apiEntity.getTags());
            apiDefinition.setListeners(apiEntity.getListeners());
            apiDefinition.setEndpointGroups(apiEntity.getEndpointGroups());
            apiDefinition.setAnalytics(apiEntity.getAnalytics());
            apiDefinition.setFailover(apiEntity.getFailover());
            if (apiEntity.getProperties() != null) {
                apiDefinition.setProperties(apiEntity.getProperties().stream().map(propertyEntity -> new Property(propertyEntity.getKey(), propertyEntity.getValue())).collect(Collectors.toList()));
            }
            apiDefinition.setResources(apiEntity.getResources());
            apiDefinition.setFlowExecution(apiEntity.getFlowExecution());
            apiDefinition.setFlows(apiEntity.getFlows());
            apiDefinition.setResponseTemplates(apiEntity.getResponseTemplates());
            apiDefinition.setServices(apiEntity.getServices());
            return this.objectMapper.writeValueAsString((Object)apiDefinition);
        }
        catch (JsonProcessingException jse) {
            log.error("Unexpected error while generating API definition", (Throwable)jse);
            throw new TechnicalManagementException("An error occurs while trying to parse API definition " + String.valueOf((Object)jse));
        }
    }
}

