/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.specgen;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.specgen.crud_service.ApiSpecGenCrudService;
import io.gravitee.apim.core.specgen.model.ApiSpecGen;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.analytics.logging.Logging;
import io.gravitee.definition.model.v4.analytics.logging.LoggingContent;
import io.gravitee.definition.model.v4.analytics.logging.LoggingMode;
import io.gravitee.definition.model.v4.analytics.logging.LoggingPhase;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiSpecGenCrudServiceImpl
implements ApiSpecGenCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSpecGenCrudServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ObjectMapper objectMapper;
    private final ApiService apiService;

    public ApiSpecGenCrudServiceImpl(@Lazy ApiRepository apiRepository, @Lazy ApiService apiService, ObjectMapper objectMapper) {
        this.apiRepository = apiRepository;
        this.objectMapper = objectMapper;
        this.apiService = apiService;
    }

    @Override
    public void enableAnalyticsLogging(ApiSpecGen apiSpecGen, String userId) {
        try {
            Api apiDefinition = (Api)this.objectMapper.readValue(apiSpecGen.definition(), Api.class);
            boolean deploy = false;
            Analytics analytics = Optional.ofNullable(apiDefinition.getAnalytics()).orElse(ApiSpecGenCrudServiceImpl.getAnalytics());
            deploy = ApiSpecGenCrudServiceImpl.enableAnalytics(analytics, deploy);
            Logging logging = analytics.getLogging();
            deploy = ApiSpecGenCrudServiceImpl.enableEndointMode(logging, deploy);
            LoggingContent content = logging.getContent();
            deploy = ApiSpecGenCrudServiceImpl.enableHeaders(content, deploy);
            deploy = ApiSpecGenCrudServiceImpl.enablePayload(content, deploy);
            LoggingPhase phase = logging.getPhase();
            deploy = ApiSpecGenCrudServiceImpl.enableRequest(phase, deploy);
            deploy = ApiSpecGenCrudServiceImpl.enableResponse(phase, deploy);
            if (deploy) {
                apiDefinition.setAnalytics(analytics);
                String definition = this.objectMapper.writeValueAsString((Object)apiDefinition);
                this.apiRepository.findById((Object)apiSpecGen.id()).ifPresent(api -> this.updateApi((io.gravitee.repository.management.model.Api)api, definition, userId));
            }
        }
        catch (Exception e) {
            log.error("Could not enable analytics for api {}, reason: {}", new Object[]{apiSpecGen.id(), e.getMessage(), e});
        }
    }

    private void updateApi(io.gravitee.repository.management.model.Api api, String definition, String userId) {
        try {
            api.setDefinition(definition);
            api = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
            this.deploy(api, userId);
        }
        catch (TechnicalException technicalException) {
            throw new RuntimeException(technicalException);
        }
    }

    private void deploy(io.gravitee.repository.management.model.Api api, String userId) {
        Completable.defer(() -> Completable.fromRunnable(() -> {
            ApiDeploymentEntity apiDeploymentEntity = new ApiDeploymentEntity();
            apiDeploymentEntity.setDeploymentLabel("Analytics enabled by spec-gen");
            this.apiService.deploy(GraviteeContext.getExecutionContext(), api.getId(), userId, EventType.PUBLISH_API, apiDeploymentEntity);
        })).subscribeOn(Schedulers.io()).subscribe(() -> log.debug("Api [{}] successfully deployed by user [{}]", (Object)api.getId(), (Object)userId), t -> log.error("Could not deploy api [{}], userId: [{}]", new Object[]{api.getId(), userId, t}));
    }

    private static boolean enableResponse(LoggingPhase phase, boolean deploy) {
        if (!phase.isResponse()) {
            phase.setResponse(true);
            deploy = true;
        }
        return deploy;
    }

    private static boolean enableRequest(LoggingPhase phase, boolean deploy) {
        if (!phase.isRequest()) {
            phase.setRequest(true);
            deploy = true;
        }
        return deploy;
    }

    private static boolean enablePayload(LoggingContent content, boolean deploy) {
        if (!content.isPayload()) {
            content.setPayload(true);
            deploy = true;
        }
        return deploy;
    }

    private static boolean enableHeaders(LoggingContent content, boolean deploy) {
        if (!content.isHeaders()) {
            content.setHeaders(true);
            deploy = true;
        }
        return deploy;
    }

    private static boolean enableEndointMode(Logging logging, boolean deploy) {
        if (!logging.getMode().isEndpoint()) {
            logging.getMode().setEndpoint(true);
            deploy = true;
        }
        return deploy;
    }

    private static boolean enableAnalytics(Analytics analytics, boolean deploy) {
        if (!analytics.isEnabled()) {
            analytics.setEnabled(true);
            deploy = true;
        }
        return deploy;
    }

    @NotNull
    private static Analytics getAnalytics() {
        return Analytics.builder().logging(ApiSpecGenCrudServiceImpl.getLogging()).build();
    }

    @NotNull
    private static Logging getLogging() {
        Logging logging = new Logging();
        logging.setMode(LoggingMode.builder().build());
        logging.setContent(LoggingContent.builder().build());
        logging.setPhase(LoggingPhase.builder().build());
        return logging;
    }
}

