/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api_health.model.AverageHealthCheckResponseTime;
import io.gravitee.apim.core.api_health.model.HealthCheckLog;
import io.gravitee.apim.core.api_health.query_service.ApiHealthQueryService;
import io.gravitee.apim.infra.adapter.ApiHealthAdapter;
import io.gravitee.repository.healthcheck.v4.model.ApiFieldPeriod;
import io.gravitee.repository.healthcheck.v4.model.AverageHealthCheckResponseTime;
import io.gravitee.repository.healthcheck.v4.model.AverageHealthCheckResponseTimeOvertimeQuery;
import io.gravitee.repository.healthcheck.v4.model.HealthCheckLog;
import io.gravitee.repository.healthcheck.v4.model.HealthCheckLogQuery;
import io.gravitee.repository.management.api.search.Pageable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApiHealthAdapterImpl
implements ApiHealthAdapter {
    @Override
    public ApiFieldPeriod map(ApiHealthQueryService.ApiFieldPeriodQuery source) {
        if (source == null) {
            return null;
        }
        ApiFieldPeriod.ApiFieldPeriodBuilder apiFieldPeriod = ApiFieldPeriod.builder();
        apiFieldPeriod.apiId(source.apiId());
        apiFieldPeriod.field(source.field());
        apiFieldPeriod.from(source.from());
        apiFieldPeriod.to(source.to());
        return apiFieldPeriod.build();
    }

    @Override
    public io.gravitee.apim.core.api_health.model.AverageHealthCheckResponseTime map(AverageHealthCheckResponseTime source) {
        if (source == null) {
            return null;
        }
        AverageHealthCheckResponseTime.AverageHealthCheckResponseTimeBuilder averageHealthCheckResponseTime = io.gravitee.apim.core.api_health.model.AverageHealthCheckResponseTime.builder();
        averageHealthCheckResponseTime.globalResponseTimeMs(source.globalResponseTimeMs());
        Map map = source.groupedResponseTimeMs();
        if (map != null) {
            averageHealthCheckResponseTime.groupedResponseTimeMs(new LinkedHashMap<String, Long>(map));
        }
        return averageHealthCheckResponseTime.build();
    }

    @Override
    public AverageHealthCheckResponseTimeOvertimeQuery map(ApiHealthQueryService.AverageHealthCheckResponseTimeOvertimeQuery source) {
        if (source == null) {
            return null;
        }
        AverageHealthCheckResponseTimeOvertimeQuery.AverageHealthCheckResponseTimeOvertimeQueryBuilder averageHealthCheckResponseTimeOvertimeQuery = AverageHealthCheckResponseTimeOvertimeQuery.builder();
        averageHealthCheckResponseTimeOvertimeQuery.apiId(source.apiId());
        averageHealthCheckResponseTimeOvertimeQuery.from(source.from());
        averageHealthCheckResponseTimeOvertimeQuery.to(source.to());
        averageHealthCheckResponseTimeOvertimeQuery.interval(source.interval());
        return averageHealthCheckResponseTimeOvertimeQuery.build();
    }

    @Override
    public HealthCheckLogQuery map(ApiHealthQueryService.SearchLogsQuery source) {
        if (source == null) {
            return null;
        }
        String apiId = null;
        Instant from = null;
        Instant to = null;
        Optional<Boolean> success = null;
        Pageable pageable = null;
        apiId = source.apiId();
        from = source.from();
        to = source.to();
        success = source.success();
        pageable = this.map(source.pageable());
        HealthCheckLogQuery healthCheckLogQuery = new HealthCheckLogQuery(apiId, from, to, success, pageable);
        return healthCheckLogQuery;
    }

    @Override
    public io.gravitee.apim.core.api_health.model.HealthCheckLog map(HealthCheckLog source) {
        if (source == null) {
            return null;
        }
        HealthCheckLog.HealthCheckLogBuilder healthCheckLog = io.gravitee.apim.core.api_health.model.HealthCheckLog.builder();
        healthCheckLog.id(source.id());
        healthCheckLog.timestamp(source.timestamp());
        healthCheckLog.apiId(source.apiId());
        healthCheckLog.endpointName(source.endpointName());
        healthCheckLog.gatewayId(source.gatewayId());
        healthCheckLog.responseTime(source.responseTime());
        healthCheckLog.success(source.success());
        healthCheckLog.steps(this.stepListToStepList(source.steps()));
        return healthCheckLog.build();
    }

    protected HealthCheckLog.Request requestToRequest(HealthCheckLog.Request request) {
        if (request == null) {
            return null;
        }
        String uri = null;
        String method = null;
        LinkedHashMap<String, String> headers = null;
        uri = request.uri();
        method = request.method();
        Map map = request.headers();
        if (map != null) {
            headers = new LinkedHashMap<String, String>(map);
        }
        HealthCheckLog.Request request1 = new HealthCheckLog.Request(uri, method, headers);
        return request1;
    }

    protected HealthCheckLog.Response responseToResponse(HealthCheckLog.Response response) {
        if (response == null) {
            return null;
        }
        int status = 0;
        String body = null;
        LinkedHashMap<String, String> headers = null;
        status = response.status();
        body = response.body();
        Map map = response.headers();
        if (map != null) {
            headers = new LinkedHashMap<String, String>(map);
        }
        HealthCheckLog.Response response1 = new HealthCheckLog.Response(status, body, headers);
        return response1;
    }

    protected HealthCheckLog.Step stepToStep(HealthCheckLog.Step step) {
        if (step == null) {
            return null;
        }
        String name = null;
        boolean success = false;
        String message = null;
        HealthCheckLog.Request request = null;
        HealthCheckLog.Response response = null;
        name = step.name();
        success = step.success();
        message = step.message();
        request = this.requestToRequest(step.request());
        response = this.responseToResponse(step.response());
        HealthCheckLog.Step step1 = new HealthCheckLog.Step(name, success, message, request, response);
        return step1;
    }

    protected List<HealthCheckLog.Step> stepListToStepList(List<HealthCheckLog.Step> list) {
        if (list == null) {
            return null;
        }
        ArrayList<HealthCheckLog.Step> list1 = new ArrayList<HealthCheckLog.Step>(list.size());
        for (HealthCheckLog.Step step : list) {
            list1.add(this.stepToStep(step));
        }
        return list1;
    }
}

