/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.group;

import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.group.domain_service.ValidateGroupCRDDomainService;
import io.gravitee.apim.core.group.model.crd.GroupCRDSpec;
import io.gravitee.apim.core.member.domain_service.ValidateCRDMembersDomainService;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.member.model.RoleScope;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.apim.infra.adapter.GroupCRDAdapter;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.service.RoleService;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ValidateGroupCRDDomainServiceImpl
implements ValidateGroupCRDDomainService {
    private final ValidateCRDMembersDomainService membersValidator;
    private final RoleService roleService;

    @Override
    public Validator.Result<ValidateGroupCRDDomainService.Input> validateAndSanitize(ValidateGroupCRDDomainService.Input input) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        this.validateAndSanitizeId(input.spec().getId()).peek(id -> input.spec().setId((String)id), errors::addAll);
        this.validateAndSanitizedName(input.spec().getName()).peek(name -> input.spec().setName((String)name), errors::addAll);
        this.validateAndSanitizeMembers(input).peek(members -> input.spec().setMembers((Set<GroupCRDSpec.Member>)members), errors::addAll);
        return Validator.Result.ofBoth(input, errors);
    }

    private Validator.Result<String> validateAndSanitizeId(String id) {
        if (StringUtils.isEmpty(id)) {
            return Validator.Result.ofErrors(List.of(Validator.Error.severe("property [id] must be a valid UUID", new Object[0])));
        }
        try {
            return Validator.Result.ofValue(UUID.fromString(id).toString());
        }
        catch (IllegalArgumentException e) {
            return Validator.Result.ofErrors(List.of(Validator.Error.severe("property [id] must be a valid UUID", new Object[0])));
        }
    }

    private Validator.Result<String> validateAndSanitizedName(String name) {
        if (StringUtils.isEmpty(name)) {
            return Validator.Result.ofErrors(List.of(Validator.Error.severe("property [name] must not be empty", new Object[0])));
        }
        return Validator.Result.ofValue(name);
    }

    private Validator.Result<Set<GroupCRDSpec.Member>> validateAndSanitizeMembers(ValidateGroupCRDDomainService.Input input) {
        if (CollectionUtils.isEmpty(input.spec().getMembers())) {
            return Validator.Result.ofBoth(Set.of(), List.of());
        }
        HashMap sanitizedGroupMembers = new HashMap();
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        Map<RoleScope, RoleEntity> defaultRoles = this.getDefaultRoles(input.auditInfo());
        for (GroupCRDSpec.Member member : input.spec().getMembers()) {
            member.setRoles(member.getRoles() == null ? new HashMap<RoleScope, String>() : new HashMap<RoleScope, String>(member.getRoles()));
            member.getRoles().computeIfAbsent(RoleScope.API, scope -> ((RoleEntity)defaultRoles.get(scope)).getName());
            member.getRoles().computeIfAbsent(RoleScope.APPLICATION, scope -> ((RoleEntity)defaultRoles.get(scope)).getName());
            member.getRoles().computeIfAbsent(RoleScope.INTEGRATION, scope -> ((RoleEntity)defaultRoles.get(scope)).getName());
        }
        Set<MemberCRD> apiMembers = GroupCRDAdapter.INSTANCE.toApiMemberCRDSet(input.spec().getMembers());
        Set<MemberCRD> applicationMembers = GroupCRDAdapter.INSTANCE.toApplicationMemberCRDSet(input.spec().getMembers());
        Set<MemberCRD> integrationMembers = GroupCRDAdapter.INSTANCE.toIntegrationMemberCRDSet(input.spec().getMembers());
        this.membersValidator.validateAndSanitize(new ValidateCRDMembersDomainService.Input(input.auditInfo(), MembershipReferenceType.API, apiMembers)).peek(output -> ValidateGroupCRDDomainServiceImpl.groupMembersById(RoleScope.API, output.members(), sanitizedGroupMembers), errors::addAll);
        this.membersValidator.validateAndSanitize(new ValidateCRDMembersDomainService.Input(input.auditInfo(), MembershipReferenceType.APPLICATION, applicationMembers)).peek(output -> ValidateGroupCRDDomainServiceImpl.groupMembersById(RoleScope.APPLICATION, output.members(), sanitizedGroupMembers), errors::addAll);
        this.membersValidator.validateAndSanitize(new ValidateCRDMembersDomainService.Input(input.auditInfo(), MembershipReferenceType.INTEGRATION, integrationMembers)).peek(output -> ValidateGroupCRDDomainServiceImpl.groupMembersById(RoleScope.INTEGRATION, output.members(), sanitizedGroupMembers), errors::addAll);
        return Validator.Result.ofBoth(new HashSet(sanitizedGroupMembers.values()), errors);
    }

    private Map<RoleScope, RoleEntity> getDefaultRoles(AuditInfo auditInfo) {
        return this.roleService.findDefaultRoleByScopes(auditInfo.organizationId(), io.gravitee.rest.api.model.permissions.RoleScope.API, io.gravitee.rest.api.model.permissions.RoleScope.APPLICATION, io.gravitee.rest.api.model.permissions.RoleScope.INTEGRATION).stream().collect(Collectors.toMap(role -> RoleScope.valueOf(role.getScope().name()), Function.identity()));
    }

    private static void groupMembersById(RoleScope roleScope, Set<MemberCRD> members, HashMap<String, GroupCRDSpec.Member> groups) {
        for (MemberCRD member : members) {
            groups.computeIfPresent(member.getId(), (id, groupMember) -> ValidateGroupCRDDomainServiceImpl.addMemberRole(roleScope, groupMember, member));
            groups.computeIfAbsent(member.getId(), id -> ValidateGroupCRDDomainServiceImpl.initGroupMember(roleScope, member));
        }
    }

    private static GroupCRDSpec.Member addMemberRole(RoleScope roleScope, GroupCRDSpec.Member groupMember, MemberCRD member) {
        groupMember.getRoles().put(roleScope, member.getRole());
        return groupMember;
    }

    private static GroupCRDSpec.Member initGroupMember(RoleScope roleScope, MemberCRD member) {
        return GroupCRDSpec.Member.builder().id(member.getId()).source(member.getSource()).sourceId(member.getSourceId()).roles(ValidateGroupCRDDomainServiceImpl.initMemberRoles(roleScope, member.getRole())).build();
    }

    private static Map<RoleScope, String> initMemberRoles(RoleScope roleScope, String roleName) {
        EnumMap<RoleScope, String> roles = new EnumMap<RoleScope, String>(RoleScope.class);
        roles.put(roleScope, roleName);
        return roles;
    }

    @Generated
    public ValidateGroupCRDDomainServiceImpl(ValidateCRDMembersDomainService membersValidator, RoleService roleService) {
        this.membersValidator = membersValidator;
        this.roleService = roleService;
    }
}

