/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.plan;

import io.gravitee.apim.core.plan.domain_service.PlanSynchronizationService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.gravitee.rest.api.model.v4.plan.BasePlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.processor.SynchronizationService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PlanSynchronizationLegacyWrapper
implements PlanSynchronizationService {
    private final SynchronizationService synchronizationService;

    public PlanSynchronizationLegacyWrapper(SynchronizationService synchronizationService) {
        this.synchronizationService = synchronizationService;
    }

    @Override
    public boolean checkSynchronized(Plan oldPlan, List<Flow> oldFlows, Plan newPlan, List<Flow> newFlows) {
        PlanEntity oldPlanEntity = PlanAdapter.INSTANCE.toEntityV4(oldPlan);
        oldPlanEntity.setFlows(oldFlows);
        PlanEntity newPlanEntity = PlanAdapter.INSTANCE.toEntityV4(newPlan);
        newPlanEntity.setFlows(newFlows);
        return this.synchronizationService.checkSynchronization(PlanEntity.class, oldPlanEntity, newPlanEntity) && this.synchronizationService.checkSynchronization(BasePlanEntity.class, oldPlanEntity, newPlanEntity);
    }

    @Override
    public boolean checkNativePlanSynchronized(Plan oldPlan, List<NativeFlow> oldFlows, Plan newPlan, List<NativeFlow> newFlows) {
        NativePlanEntity oldPlanEntity = PlanAdapter.INSTANCE.toNativePlanEntityV4(oldPlan);
        oldPlanEntity.setFlows(oldFlows);
        NativePlanEntity newPlanEntity = PlanAdapter.INSTANCE.toNativePlanEntityV4(newPlan);
        newPlanEntity.setFlows(newFlows);
        return this.synchronizationService.checkSynchronization(NativePlanEntity.class, oldPlanEntity, newPlanEntity) && this.synchronizationService.checkSynchronization(BasePlanEntity.class, oldPlanEntity, newPlanEntity);
    }
}

