/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.subscription;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.infra.adapter.SubscriptionAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionCrudServiceImpl
implements SubscriptionCrudService {
    private final SubscriptionRepository subscriptionRepository;
    private final SubscriptionAdapter subscriptionAdapter;

    public SubscriptionCrudServiceImpl(@Lazy SubscriptionRepository subscriptionRepository, SubscriptionAdapter subscriptionAdapter) {
        this.subscriptionRepository = subscriptionRepository;
        this.subscriptionAdapter = subscriptionAdapter;
    }

    @Override
    public SubscriptionEntity get(String subscriptionId) {
        try {
            return this.subscriptionRepository.findById((Object)subscriptionId).map(this.subscriptionAdapter::toEntity).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find a subscription by id: " + subscriptionId, e);
        }
    }

    @Override
    public SubscriptionEntity update(SubscriptionEntity subscriptionEntity) {
        try {
            Subscription result = (Subscription)this.subscriptionRepository.update((Object)this.subscriptionAdapter.fromEntity(subscriptionEntity));
            return this.subscriptionAdapter.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to update the subscription: " + subscriptionEntity.getId(), e);
        }
    }

    @Override
    public void delete(String subscriptionId) {
        try {
            this.subscriptionRepository.delete((Object)subscriptionId);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to delete the subscription with id: %s", subscriptionId), e);
        }
    }
}

