/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.specgen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.specgen.model.ApiSpecGen;
import io.gravitee.apim.core.specgen.service_provider.OasProvider;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OasProviderImpl
implements OasProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OasProviderImpl.class);
    private static final ObjectMapper mapper = Yaml.mapper();

    @Override
    public String decorateSpecification(ApiSpecGen api, String content) {
        try {
            SwaggerParseResult parseResult = OasProviderImpl.parse(content);
            OpenAPI oas = parseResult.getOpenAPI();
            if (oas == null) {
                String messages = String.join((CharSequence)", ", parseResult.getMessages());
                log.warn("Could not parse generated OpenAPI Specification for api [{}], reason: [{}]", (Object)api.id(), (Object)messages);
                return content;
            }
            if (oas.getInfo() == null) {
                oas.setInfo(new Info());
            }
            Info info = oas.getInfo();
            info.setTitle(api.name());
            info.setVersion(api.version());
            info.setDescription(OasProviderImpl.getDescription(api, info.getDescription()));
            return mapper.writeValueAsString((Object)oas);
        }
        catch (JsonProcessingException e) {
            log.warn("Could not write generated OpenAPI Specification for api [{}]", (Object)api.id(), (Object)e);
            return content;
        }
    }

    private static SwaggerParseResult parse(String content) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        options.setResolveFully(true);
        return new OpenAPIV3Parser().readContents(content, null, options);
    }

    private static String getDescription(ApiSpecGen api, String oasDescription) {
        return Optional.ofNullable(api.description()).filter(Predicate.not(String::isBlank)).orElse(oasDescription);
    }
}

