/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.application;

import io.gravitee.apim.core.application.query_service.ApplicationQueryService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.infra.adapter.ApplicationAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApplicationQueryServiceImpl
extends AbstractService
implements ApplicationQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationQueryServiceImpl.class);
    private final ApplicationRepository applicationRepository;

    public ApplicationQueryServiceImpl(@Lazy ApplicationRepository applicationRepository) {
        this.applicationRepository = applicationRepository;
    }

    @Override
    public Set<BaseApplicationEntity> findByEnvironment(String environmentId) {
        try {
            return CollectionUtils.stream(this.applicationRepository.findAllByEnvironment(environmentId, ApplicationStatus.values())).map(ApplicationAdapter.INSTANCE::toEntity).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding applications by environment", (Throwable)e);
            throw new TechnicalManagementException("An error occurred while finding applications by environment id: " + environmentId, e);
        }
    }
}

