/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.SharedPolicyGroupRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.SharedPolicyGroupCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.service.common.ExecutionContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SharedPolicyGroupHRIDUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SharedPolicyGroupHRIDUpgrader.class);
    @Lazy
    @Autowired
    private SharedPolicyGroupRepository sharedPolicyGroupRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;

    public boolean upgrade() {
        try {
            for (Environment environment : this.environmentRepository.findAll()) {
                this.setHRIDs(new ExecutionContext(environment));
            }
            return true;
        }
        catch (TechnicalException e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
    }

    public int getOrder() {
        return 706;
    }

    private void setHRIDs(ExecutionContext executionContext) throws TechnicalException {
        Pageable pageable = new PageableBuilder().pageNumber(0).pageSize(Integer.MAX_VALUE).build();
        this.sharedPolicyGroupRepository.search(SharedPolicyGroupCriteria.builder().environmentId(executionContext.getEnvironmentId()).build(), pageable, null).getContent().forEach(sharedPolicyGroup -> {
            try {
                sharedPolicyGroup.setHrid(sharedPolicyGroup.getCrossId());
                this.sharedPolicyGroupRepository.update(sharedPolicyGroup);
            }
            catch (TechnicalException e) {
                log.error("Unable to set HRID for Shared Policy Group {}", (Object)sharedPolicyGroup.getId(), (Object)e);
                throw new RuntimeException(e);
            }
        });
    }
}

