/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Plan;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlanApiTypeUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanApiTypeUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(this::updatePlanApiType);
    }

    private boolean updatePlanApiType() throws TechnicalException {
        log.info("Starting migration of plan api_type...");
        List apis = this.apiRepository.search(new ApiCriteria.Builder().definitionVersion(List.of(DefinitionVersion.V4)).build(), null, ApiFieldFilter.defaultFields()).toList();
        for (Api api : apis) {
            try {
                this.populatePlansWithApiTypeForApi(api);
            }
            catch (TechnicalException e) {
                throw new TechnicalException("Error populating plans for API " + api.getId(), (Throwable)e);
            }
        }
        log.info("Migration of plan api_type completed.");
        return true;
    }

    private void populatePlansWithApiTypeForApi(Api api) throws TechnicalException {
        try {
            for (Plan plan : this.planRepository.findByApi(api.getId())) {
                this.populateApiType(plan, api.getType());
            }
        }
        catch (TechnicalException e) {
            throw new TechnicalException("Unable to migrate api_type for API" + api.getId() + " {} and its plans", (Throwable)e);
        }
    }

    private void populateApiType(Plan plan, ApiType apiType) throws TechnicalException {
        plan.setApiType(apiType);
        this.planRepository.update((Object)plan);
        log.info("Updated plan {} with api_type {}", (Object)plan.getId(), (Object)apiType);
    }

    public int getOrder() {
        return 705;
    }
}

