/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiV4CategoriesUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiV4CategoriesUpgrader.class);
    private final ApiRepository apiRepository;
    private final CategoryRepository categoryRepository;

    @Autowired
    public ApiV4CategoriesUpgrader(@Lazy ApiRepository apiRepository, @Lazy CategoryRepository categoryRepository) {
        this.apiRepository = apiRepository;
        this.categoryRepository = categoryRepository;
    }

    public int getOrder() {
        return 701;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(this::migrateV4ApiCategories);
    }

    private boolean migrateV4ApiCategories() throws TechnicalException {
        Set categories;
        try {
            categories = this.categoryRepository.findAll();
        }
        catch (TechnicalException e) {
            log.error("An error occurred when finding all categories", (Throwable)e);
            throw new TechnicalException((Throwable)e);
        }
        if (Objects.isNull(categories) || categories.isEmpty()) {
            return true;
        }
        HashMap envByCategoryKeyId = new HashMap();
        HashMap categoryIdKeyMap = new HashMap();
        categories.forEach(category -> {
            envByCategoryKeyId.computeIfPresent(category.getEnvironmentId(), (envId, keyIdMap) -> {
                keyIdMap.put(category.getKey(), category.getId());
                return keyIdMap;
            });
            envByCategoryKeyId.computeIfAbsent(category.getEnvironmentId(), envId -> {
                HashMap<String, String> keyIdMap = new HashMap<String, String>();
                keyIdMap.put(category.getKey(), category.getId());
                return keyIdMap;
            });
            categoryIdKeyMap.put(category.getId(), category.getKey());
        });
        AtomicInteger modelCounter = new AtomicInteger(0);
        this.apiRepository.search(new ApiCriteria.Builder().definitionVersion(List.of(DefinitionVersion.V4)).build(), null, ApiFieldFilter.allFields()).filter(v4Api -> Objects.nonNull(v4Api.getCategories()) && !v4Api.getCategories().isEmpty()).forEach(v4Api -> {
            try {
                Set newCategories = v4Api.getCategories().stream().map(category -> {
                    if (envByCategoryKeyId.containsKey(v4Api.getEnvironmentId()) && ((Map)envByCategoryKeyId.get(v4Api.getEnvironmentId())).containsKey(category)) {
                        return (String)((Map)envByCategoryKeyId.get(v4Api.getEnvironmentId())).get(category);
                    }
                    if (categoryIdKeyMap.containsKey(category)) {
                        return category;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                v4Api.setCategories(newCategories);
                this.apiRepository.update(v4Api);
                modelCounter.incrementAndGet();
            }
            catch (Exception e) {
                log.error("Unable to migrate categories for api {}", (Object)v4Api.getId(), (Object)e);
            }
        });
        log.info("{} v4 APIs have been migrated to use category ids instead of keys", (Object)modelCounter.get());
        return true;
    }
}

