/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.service.common.ExecutionContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiHRIDUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiHRIDUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;

    public boolean upgrade() {
        try {
            for (Environment environment : this.environmentRepository.findAll()) {
                this.setHRIDs(new ExecutionContext(environment));
            }
            return true;
        }
        catch (TechnicalException e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
    }

    public int getOrder() {
        return 707;
    }

    private void setHRIDs(ExecutionContext executionContext) {
        this.apiRepository.search(new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).build(), null, new ApiFieldFilter.Builder().excludePicture().build()).forEach(api -> {
            api.setHrid(api.getCrossId());
            try {
                this.apiRepository.update(api);
            }
            catch (TechnicalException e) {
                log.error("Unable to set HRID for API {}", (Object)api.getId(), (Object)e);
                throw new RuntimeException(e);
            }
        });
    }
}

