/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class UuidString {
    private static final UnaryOperator<String> DEFAULT_GENERATOR = seed -> {
        if (seed == null) {
            return io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random());
        }
        return io.gravitee.common.utils.UUID.toString((UUID)UUID.nameUUIDFromBytes(seed.getBytes()));
    };
    private static UnaryOperator<String> uuidGenerator = DEFAULT_GENERATOR;

    private UuidString() {
    }

    public static String generateRandom() {
        return (String)uuidGenerator.apply(null);
    }

    static String generateFrom(String ... seeds) {
        if (Stream.of(seeds).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Seeds must not be null");
        }
        StringBuilder b = new StringBuilder();
        for (String seed : seeds) {
            b.append(seed);
        }
        return (String)uuidGenerator.apply(b.toString());
    }

    public static String generateForEnvironment(String environmentId, String ... fields) {
        if (Stream.of(fields).anyMatch(Objects::isNull)) {
            return UuidString.generateRandom();
        }
        LinkedList<String> strings = new LinkedList<String>(Arrays.asList(fields));
        strings.addFirst(environmentId);
        return UuidString.generateFrom(strings.toArray(new String[0]));
    }

    public static void overrideGenerator(UnaryOperator<String> newGenerator) {
        uuidGenerator = newGenerator;
    }

    public static void overrideGenerator(Supplier<String> newGenerator) {
        uuidGenerator = seed -> (String)newGenerator.get();
    }

    public static void reset() {
        uuidGenerator = DEFAULT_GENERATOR;
    }
}

