/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import io.gravitee.repository.common.query.QueryContext;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import java.util.Objects;
import java.util.Optional;

public class ExecutionContext {
    private final Optional<String> organizationId;
    private final Optional<String> environmentId;

    public ExecutionContext() {
        this.organizationId = Optional.empty();
        this.environmentId = Optional.empty();
    }

    public ExecutionContext(String organizationId, String environmentId) {
        this.organizationId = Optional.ofNullable(organizationId);
        this.environmentId = Optional.ofNullable(environmentId);
    }

    public ExecutionContext(String organizationId) {
        this(organizationId, null);
    }

    public ExecutionContext(OrganizationEntity organization) {
        this(organization.getId(), null);
    }

    public ExecutionContext(EnvironmentEntity environment) {
        this(environment.getOrganizationId(), environment.getId());
    }

    public ExecutionContext(Environment environment) {
        this(environment.getOrganizationId(), environment.getId());
    }

    public ExecutionContext(Organization organization) {
        this(organization.getId(), null);
    }

    public String getOrganizationId() {
        return this.organizationId.orElse(null);
    }

    public String getEnvironmentId() throws EnvironmentNotFoundException {
        return this.environmentId.orElseThrow(() -> new EnvironmentNotFoundException(null));
    }

    public boolean hasOrganizationId() {
        return this.organizationId.isPresent();
    }

    public boolean hasEnvironmentId() {
        return this.environmentId.isPresent();
    }

    public ReferenceContext getReferenceContext() {
        return this.environmentId.map(envId -> ReferenceContext.builder().referenceId((String)envId).referenceType(ReferenceContext.Type.ENVIRONMENT).build()).orElseGet(() -> this.organizationId.map(orgId -> ReferenceContext.builder().referenceId((String)orgId).referenceType(ReferenceContext.Type.ORGANIZATION).build()).orElse(null));
    }

    public QueryContext getQueryContext() {
        return new QueryContext(this.getOrganizationId(), this.getEnvironmentId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionContext that = (ExecutionContext)o;
        return Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.environmentId, that.environmentId);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.environmentId);
    }

    public String toString() {
        return "ExecutionContext{organizationId='" + String.valueOf(this.organizationId) + "', environmentId=" + String.valueOf(this.environmentId) + "}";
    }
}

