/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.event;

import com.google.common.util.concurrent.AtomicLongMap;
import io.gravitee.apim.core.event.crud_service.EventCrudService;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.infra.adapter.EventAdapter;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Flowable;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class EventCrudServiceLegacyWrapper
implements EventCrudService {
    private final EventService eventService;
    private final EventRepository eventRepository;

    public EventCrudServiceLegacyWrapper(EventService eventService, @Lazy EventRepository eventRepository) {
        this.eventService = eventService;
        this.eventRepository = eventRepository;
    }

    @Override
    public Event createEvent(String organizationId, String environmentId, Set<String> environmentIds, EventType eventType, Object content, Map<Event.EventProperties, String> properties) {
        return EventAdapter.INSTANCE.fromEntity(this.eventService.createEvent(new ExecutionContext(organizationId, environmentId), environmentIds, organizationId, eventType, content, EventAdapter.INSTANCE.toStringEventPropertiesMap(properties)));
    }

    @Override
    public Event get(String organizationId, String environmentId, String eventId) {
        return EventAdapter.INSTANCE.fromEntity(this.eventService.findById(new ExecutionContext(organizationId, environmentId), eventId));
    }

    @Override
    public void cleanupEvents(String environmentId, int nbEventsToKeep, Duration timeToLive) {
        AtomicLongMap counters = AtomicLongMap.create();
        Flowable.fromStream((Stream)this.eventRepository.findGatewayEvents(environmentId)).filter(event -> event.apiId() != null && counters.incrementAndGet((Object)event.apiId()) > (long)nbEventsToKeep).map(EventRepository.EventToClean::id).buffer(20).takeUntil((Publisher)Flowable.timer((long)timeToLive.toSeconds(), (TimeUnit)TimeUnit.SECONDS)).blockingForEach(arg_0 -> ((EventRepository)this.eventRepository).delete(arg_0));
    }
}

