/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.search.CommandCriteria;
import io.gravitee.repository.management.model.Command;
import io.gravitee.repository.management.model.Environment;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CommandOrganizationUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandOrganizationUpgrader.class);
    private final EnvironmentRepository environmentRepository;
    private final CommandRepository commandRepository;

    @Autowired
    public CommandOrganizationUpgrader(@Lazy EnvironmentRepository environmentRepository, @Lazy CommandRepository commandRepository) {
        this.environmentRepository = environmentRepository;
        this.commandRepository = commandRepository;
    }

    public int getOrder() {
        return 500;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(() -> {
            for (Environment environment : this.environmentRepository.findAll()) {
                this.updateCommands(environment);
            }
            return true;
        });
    }

    private void updateCommands(Environment environment) throws TechnicalException {
        CommandCriteria criteria = new CommandCriteria.Builder().environmentId(environment.getId()).build();
        for (Command command : this.commandRepository.search(criteria)) {
            this.updateOrganizationId(command, environment.getOrganizationId());
        }
    }

    private void updateOrganizationId(Command command, String organizationId) throws TechnicalException {
        command.setOrganizationId(organizationId);
        this.commandRepository.update((Object)command);
    }
}

