/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.integration.api.model.Api;
import io.gravitee.integration.api.model.Page;
import io.gravitee.integration.api.model.Plan;
import io.gravitee.integration.api.model.PlanSecurityType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ValueMapping;
import org.mapstruct.ValueMappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface IntegrationAdapter {
    public static final IntegrationAdapter INSTANCE = (IntegrationAdapter)Mappers.getMapper(IntegrationAdapter.class);
    public static final SpecificApiAdapter SPECIFIC_API_INTEGRATION_ADAPTER = (SpecificApiAdapter)Mappers.getMapper(SpecificApiAdapter.class);
    public static final SpecificA2aAdapter SPECIFIC_A2A_INTEGRATION_ADAPTER = (SpecificA2aAdapter)Mappers.getMapper(SpecificA2aAdapter.class);

    default public Integration toEntity(io.gravitee.repository.management.model.Integration integration) {
        return integration.isA2aIntegration() ? SPECIFIC_A2A_INTEGRATION_ADAPTER.toEntity(integration) : SPECIFIC_API_INTEGRATION_ADAPTER.toEntity(integration);
    }

    default public io.gravitee.repository.management.model.Integration toRepository(Integration integration) {
        Integration integration2 = integration;
        Objects.requireNonNull(integration2);
        Integration integration3 = integration2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integration.ApiIntegration.class, Integration.A2aIntegration.class}, (Object)integration3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Integration.ApiIntegration api = (Integration.ApiIntegration)integration3;
                yield SPECIFIC_API_INTEGRATION_ADAPTER.toRepository(api);
            }
            case 1 -> {
                Integration.A2aIntegration a2a = (Integration.A2aIntegration)integration3;
                yield SPECIFIC_A2A_INTEGRATION_ADAPTER.toRepository(a2a);
            }
        };
    }

    public IntegrationApi map(Api var1, String var2);

    @Mapping(source="planSecurityType", target="type")
    public IntegrationApi.Plan map(Plan var1);

    @ValueMappings(value={@ValueMapping(source="API_KEY", target="API_KEY"), @ValueMapping(source="JWT", target="<NULL>"), @ValueMapping(source="OAUTH2", target="OAUTH2")})
    public IntegrationApi.PlanType map(PlanSecurityType var1);

    public IntegrationApi.Page map(Page var1);

    default public <T extends Integration> SpecificAdapter<T> specific(T integration) {
        T t = integration;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integration.ApiIntegration.class, Integration.A2aIntegration.class}, t2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Integration.ApiIntegration ignored = (Integration.ApiIntegration)t2;
                yield SPECIFIC_API_INTEGRATION_ADAPTER;
            }
            case 1 -> {
                Integration.A2aIntegration ignored = (Integration.A2aIntegration)t2;
                yield SPECIFIC_A2A_INTEGRATION_ADAPTER;
            }
        };
    }

    @Mapper
    public static interface SpecificA2aAdapter
    extends SpecificAdapter<Integration.A2aIntegration> {
        @Override
        public Integration.A2aIntegration toEntity(io.gravitee.repository.management.model.Integration var1);

        @Override
        @Mapping(target="provider", constant="A2A")
        public io.gravitee.repository.management.model.Integration toRepository(Integration.A2aIntegration var1);
    }

    @Mapper
    public static interface SpecificApiAdapter
    extends SpecificAdapter<Integration.ApiIntegration> {
        @Override
        public Integration.ApiIntegration toEntity(io.gravitee.repository.management.model.Integration var1);

        @Override
        public io.gravitee.repository.management.model.Integration toRepository(Integration.ApiIntegration var1);
    }

    public static interface SpecificAdapter<T extends Integration> {
        public T toEntity(io.gravitee.repository.management.model.Integration var1);

        public io.gravitee.repository.management.model.Integration toRepository(T var1);
    }
}

