/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.policy.domain_service.PolicyValidationDomainService;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.debug.DebugApiProxy;
import io.gravitee.definition.model.debug.DebugApiV4;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.definition.model.v4.Api;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;

@DomainService
public class ApiPolicyValidatorDomainService {
    private final PolicyValidationDomainService policyValidationDomainService;

    public void checkPolicyConfigurations(DebugApiProxy debugApiProxy) {
        if (debugApiProxy == null) {
            throw new IllegalStateException("Api should not be null");
        }
        if (debugApiProxy instanceof io.gravitee.definition.model.Api) {
            io.gravitee.definition.model.Api api = (io.gravitee.definition.model.Api)debugApiProxy;
            HashSet<Plan> plans = new HashSet<Plan>(api.getPlans());
            switch (api.getDefinitionVersion()) {
                case V1: {
                    this.validatePathConfigurations(api, plans);
                    break;
                }
                case V2: {
                    this.validateFlowConfigurations(api, plans);
                    break;
                }
                case V4: {
                    throw new IllegalStateException("Cannot validate V4 api");
                }
            }
        }
        if (debugApiProxy instanceof DebugApiV4) {
            DebugApiV4 debugApiV4 = (DebugApiV4)debugApiProxy;
            this.validateFlowV4Configurations(debugApiV4.getApiDefinition());
        }
    }

    private void validatePathConfigurations(io.gravitee.definition.model.Api api, Set<Plan> plans) {
        Stream<Rule> pathsStream = ApiPolicyValidatorDomainService.getRulesStream(api, plans);
        if (pathsStream == null) {
            return;
        }
        pathsStream.filter(Rule::isEnabled).map(Rule::getPolicy).forEach(policy -> policy.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(policy.getName(), policy.getConfiguration())));
    }

    private static Stream<Rule> getRulesStream(io.gravitee.definition.model.Api api, Set<Plan> plans) {
        Stream pathsStream = null;
        if (api.getPaths() != null) {
            pathsStream = api.getPaths().values().stream().flatMap(Collection::stream);
        }
        if (plans != null && pathsStream != null) {
            pathsStream = Stream.concat(pathsStream, plans.stream().flatMap(plan -> plan.getPaths() != null ? plan.getPaths().values().stream().flatMap(Collection::stream) : Stream.empty()));
        }
        return pathsStream;
    }

    private void validateFlowConfigurations(io.gravitee.definition.model.Api api, Set<Plan> plans) {
        Stream<Step> flowsStream = ApiPolicyValidatorDomainService.getFlowsStream(api, plans);
        if (flowsStream == null) {
            return;
        }
        flowsStream.filter(Step::isEnabled).forEach(step -> step.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(step.getPolicy(), step.getConfiguration())));
    }

    private static Stream<Step> getFlowsStream(io.gravitee.definition.model.Api api, Set<Plan> plans) {
        Stream flowsStream = null;
        if (api.getFlows() != null) {
            flowsStream = api.getFlows().stream();
        }
        if (plans != null && flowsStream != null) {
            flowsStream = Stream.concat(flowsStream, plans.stream().flatMap(plan -> plan.getFlows() != null ? plan.getFlows().stream() : Stream.empty()));
        }
        if (flowsStream == null) {
            return null;
        }
        return flowsStream.flatMap(flow -> Stream.concat(flow.getPre() != null ? flow.getPre().stream() : Stream.empty(), flow.getPost() != null ? flow.getPost().stream() : Stream.empty()));
    }

    private void validateFlowV4Configurations(Api api) {
        Stream<io.gravitee.definition.model.v4.flow.step.Step> flowsStream = ApiPolicyValidatorDomainService.flowSteps(api);
        flowsStream.filter(io.gravitee.definition.model.v4.flow.step.Step::isEnabled).forEach(step -> step.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(step.getPolicy(), step.getConfiguration())));
    }

    private static Stream<io.gravitee.definition.model.v4.flow.step.Step> flowSteps(Api api) {
        Stream apiFlows = Optional.ofNullable(api.getFlows()).stream().flatMap(Collection::stream);
        Stream plansFlows = Optional.ofNullable(api.getPlans()).stream().flatMap(plans -> plans.stream().flatMap(plan -> Optional.ofNullable(plan.getFlows()).stream().flatMap(Collection::stream)));
        return Stream.concat(apiFlows, plansFlows).flatMap(flow -> Stream.concat(Optional.ofNullable(flow.getRequest()).stream().flatMap(Collection::stream), Optional.ofNullable(flow.getResponse()).stream().flatMap(Collection::stream)));
    }

    @Generated
    public ApiPolicyValidatorDomainService(PolicyValidationDomainService policyValidationDomainService) {
        this.policyValidationDomainService = policyValidationDomainService;
    }
}

