/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.application.ApplicationQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ApplicationService {
    public ApplicationEntity findById(ExecutionContext var1, String var2);

    public Set<ApplicationListItem> findByIds(ExecutionContext var1, Collection<String> var2);

    public Set<ApplicationListItem> findByIdsAndStatus(ExecutionContext var1, Collection<String> var2, ApplicationStatus var3);

    default public Set<ApplicationListItem> findByUser(ExecutionContext executionContext, String username) {
        return this.findByUser(executionContext, username, null);
    }

    default public Set<ApplicationListItem> findByUser(ExecutionContext executionContext, String username, Sortable sortable) {
        return this.findByUser(executionContext, username, sortable, null);
    }

    default public Set<String> findIdsByUser(ExecutionContext executionContext, String username) {
        return this.findIdsByUser(executionContext, username, null);
    }

    public Set<String> findIdsByUser(ExecutionContext var1, String var2, Sortable var3);

    public Set<String> findIdsByUserAndPermission(ExecutionContext var1, String var2, Sortable var3, RolePermission var4, RolePermissionAction ... var5);

    public List<ApplicationListItem> findByUserAndPermission(ExecutionContext var1, String var2, Sortable var3, RolePermission var4, RolePermissionAction ... var5);

    public Set<ApplicationListItem> findByUser(ExecutionContext var1, String var2, Sortable var3, Pageable var4);

    public Set<String> findIdsByOrganization(String var1);

    public Set<String> findIdsByEnvironment(ExecutionContext var1);

    public Set<ApplicationListItem> findByGroups(ExecutionContext var1, List<String> var2);

    public Set<ApplicationListItem> findByGroupsAndStatus(ExecutionContext var1, List<String> var2, String var3);

    public ApplicationEntity create(ExecutionContext var1, NewApplicationEntity var2, String var3);

    public ApplicationEntity update(ExecutionContext var1, String var2, UpdateApplicationEntity var3);

    public ApplicationEntity updateApiKeyMode(ExecutionContext var1, String var2, ApiKeyMode var3);

    public ApplicationEntity renewClientSecret(ExecutionContext var1, String var2);

    public ApplicationEntity restore(ExecutionContext var1, String var2);

    public void archive(ExecutionContext var1, String var2);

    public InlinePictureEntity getPicture(ExecutionContext var1, String var2);

    public InlinePictureEntity getBackground(ExecutionContext var1, String var2);

    public Map<String, Object> findByIdAsMap(String var1) throws TechnicalException;

    public Page<ApplicationListItem> search(ExecutionContext var1, ApplicationQuery var2, Sortable var3, Pageable var4);

    public Set<String> searchIds(ExecutionContext var1, ApplicationQuery var2, Sortable var3);

    public Set<String> findUserApplicationsIds(ExecutionContext var1, String var2, ApplicationStatus var3);
}

