/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.flow.exception;

import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.definition.model.v4.ApiType;
import java.util.Map;
import java.util.Set;

public class InvalidFlowException
extends ValidationDomainException {
    public InvalidFlowException(String message, Map<String, String> parameters) {
        super(message, parameters);
    }

    public static InvalidFlowException invalidEntrypoint(String flowName, Set<String> invalidEntrypoints) {
        return new InvalidFlowException("The flow [" + flowName + "] contains channel selector with invalid entrypoints", Map.of("flowName", flowName, "invalidEntrypoints", String.join((CharSequence)",", invalidEntrypoints)));
    }

    public static InvalidFlowException invalidSelector(String flowName, ApiType apiType, Set<String> invalidSelectors) {
        return new InvalidFlowException("The flow [" + flowName + "] contains selectors that couldn't apply to " + apiType.getLabel() + " API", Map.of("flowName", flowName, "invalidSelectors", String.join((CharSequence)",", invalidSelectors)));
    }

    public static InvalidFlowException duplicatedSelector(String flowName, Set<String> duplicatedSelectors) {
        return new InvalidFlowException("The flow [" + flowName + "] contains duplicated selectors type", Map.of("flowName", flowName, "duplicatedSelectors", String.join((CharSequence)",", duplicatedSelectors)));
    }
}

