/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.event.crud_service.EventCrudService;
import io.gravitee.apim.core.event.crud_service.EventLatestCrudService;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupHistoryCrudService;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupAuditEvent;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.model.EventType;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@DomainService
public class DeleteSharedPolicyGroupUseCase {
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final SharedPolicyGroupHistoryCrudService sharedPolicyGroupHistoryCrudService;
    private final AuditDomainService auditService;
    private final EventCrudService eventCrudService;
    private final EventLatestCrudService eventLatestCrudService;

    public Output execute(Input input) {
        SharedPolicyGroup sharedPolicyGroupToDelete = this.sharedPolicyGroupCrudService.getByEnvironmentId(input.auditInfo().environmentId(), input.sharedPolicyGroupId());
        this.publishUndeployEvent(input, sharedPolicyGroupToDelete);
        this.sharedPolicyGroupCrudService.delete(sharedPolicyGroupToDelete.getId());
        this.sharedPolicyGroupHistoryCrudService.delete(sharedPolicyGroupToDelete.getId());
        this.createAuditLog(sharedPolicyGroupToDelete, input.auditInfo());
        return new Output();
    }

    private void createAuditLog(SharedPolicyGroup sharedPolicyGroup, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(SharedPolicyGroupAuditEvent.SHARED_POLICY_GROUP_DELETED).actor(auditInfo.actor()).oldValue(sharedPolicyGroup).newValue(null).createdAt(TimeProvider.now()).properties(Map.of(AuditProperties.SHARED_POLICY_GROUP, sharedPolicyGroup.getId())).build());
    }

    private void publishUndeployEvent(Input input, SharedPolicyGroup sharedPolicyGroup) {
        Event event = this.eventCrudService.createEvent(input.auditInfo.organizationId(), input.auditInfo.environmentId(), Set.of(input.auditInfo.environmentId()), EventType.UNDEPLOY_SHARED_POLICY_GROUP, sharedPolicyGroup.getDescription(), Map.ofEntries(Map.entry(Event.EventProperties.USER, input.auditInfo.actor().userId()), Map.entry(Event.EventProperties.SHARED_POLICY_GROUP_ID, sharedPolicyGroup.getCrossId())));
        this.eventLatestCrudService.createOrPatchLatestEvent(input.auditInfo.organizationId(), sharedPolicyGroup.getId(), event);
    }

    @Generated
    public DeleteSharedPolicyGroupUseCase(SharedPolicyGroupCrudService sharedPolicyGroupCrudService, SharedPolicyGroupHistoryCrudService sharedPolicyGroupHistoryCrudService, AuditDomainService auditService, EventCrudService eventCrudService, EventLatestCrudService eventLatestCrudService) {
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.sharedPolicyGroupHistoryCrudService = sharedPolicyGroupHistoryCrudService;
        this.auditService = auditService;
        this.eventCrudService = eventCrudService;
        this.eventLatestCrudService = eventLatestCrudService;
    }

    public record Input(String sharedPolicyGroupId, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String sharedPolicyGroupId;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder sharedPolicyGroupId(String sharedPolicyGroupId) {
                this.sharedPolicyGroupId = sharedPolicyGroupId;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.sharedPolicyGroupId, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "DeleteSharedPolicyGroupUseCase.Input.InputBuilder(sharedPolicyGroupId=" + this.sharedPolicyGroupId + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output() {
    }
}

