/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.analytics;

import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.model.ResponseStatusOvertime;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.infra.adapter.ResponseStatusQueryCriteriaAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.log.v4.api.AnalyticsRepository;
import io.gravitee.repository.log.v4.model.analytics.AverageAggregate;
import io.gravitee.repository.log.v4.model.analytics.AverageConnectionDurationQuery;
import io.gravitee.repository.log.v4.model.analytics.AverageMessagesPerRequestQuery;
import io.gravitee.repository.log.v4.model.analytics.RequestResponseTimeAggregate;
import io.gravitee.repository.log.v4.model.analytics.RequestResponseTimeQueryCriteria;
import io.gravitee.repository.log.v4.model.analytics.RequestsCountQuery;
import io.gravitee.repository.log.v4.model.analytics.ResponseStatusOverTimeAggregate;
import io.gravitee.repository.log.v4.model.analytics.ResponseStatusOverTimeQuery;
import io.gravitee.repository.log.v4.model.analytics.ResponseStatusQueryCriteria;
import io.gravitee.repository.log.v4.model.analytics.ResponseTimeRangeQuery;
import io.gravitee.repository.log.v4.model.analytics.TopFailedAggregate;
import io.gravitee.repository.log.v4.model.analytics.TopFailedQueryCriteria;
import io.gravitee.repository.log.v4.model.analytics.TopHitsAggregate;
import io.gravitee.repository.log.v4.model.analytics.TopHitsQueryCriteria;
import io.gravitee.rest.api.model.analytics.TopHitsApps;
import io.gravitee.rest.api.model.v4.analytics.AverageConnectionDuration;
import io.gravitee.rest.api.model.v4.analytics.AverageMessagesPerRequest;
import io.gravitee.rest.api.model.v4.analytics.RequestResponseTime;
import io.gravitee.rest.api.model.v4.analytics.RequestsCount;
import io.gravitee.rest.api.model.v4.analytics.ResponseStatusRanges;
import io.gravitee.rest.api.model.v4.analytics.TopFailedApis;
import io.gravitee.rest.api.model.v4.analytics.TopHitsApis;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Maybe;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsQueryServiceImpl
implements AnalyticsQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyticsQueryServiceImpl.class);
    private final AnalyticsRepository analyticsRepository;

    public AnalyticsQueryServiceImpl(@Lazy AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
    }

    @Override
    public Optional<RequestsCount> searchRequestsCount(ExecutionContext executionContext, String apiId, Instant from, Instant to) {
        return this.analyticsRepository.searchRequestsCount(executionContext.getQueryContext(), new RequestsCountQuery(apiId, from, to)).map(countAggregate -> RequestsCount.builder().total(Long.valueOf(countAggregate.getTotal())).countsByEntrypoint(countAggregate.getCountBy()).build());
    }

    @Override
    public Optional<AverageMessagesPerRequest> searchAverageMessagesPerRequest(ExecutionContext executionContext, String apiId, Instant from, Instant to) {
        return this.analyticsRepository.searchAverageMessagesPerRequest(executionContext.getQueryContext(), new AverageMessagesPerRequestQuery(apiId, from, to)).map(averageAggregate -> AverageMessagesPerRequest.builder().globalAverage(Double.valueOf(averageAggregate.getAverage())).averagesByEntrypoint(averageAggregate.getAverageBy()).build());
    }

    @Override
    public Optional<ResponseStatusRanges> searchResponseStatusRanges(ExecutionContext executionContext, AnalyticsQueryParameters queryParameters) {
        ResponseStatusQueryCriteria responseStatusQueryParameters = ResponseStatusQueryCriteriaAdapter.INSTANCE.map(queryParameters);
        Optional queryResult = this.analyticsRepository.searchResponseStatusRanges(executionContext.getQueryContext(), responseStatusQueryParameters);
        return queryResult.map(analytics -> ResponseStatusRanges.builder().ranges(analytics.getRanges()).statusRangesCountByEntrypoint(analytics.getStatusRangesCountByEntrypoint()).build());
    }

    @Override
    public Optional<TopHitsApis> searchTopHitsApis(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        return this.analyticsRepository.searchTopHitsApi(executionContext.getQueryContext(), new TopHitsQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo())).map(TopHitsAggregate::getTopHitsCounts).map(topHitCounts -> topHitCounts.entrySet().stream().map(entry -> TopHitsApis.TopHitApi.builder().id((String)entry.getKey()).count(((Long)entry.getValue()).longValue()).build()).toList()).map(topHitApis -> TopHitsApis.builder().data(topHitApis).build());
    }

    @Override
    public Optional<AverageConnectionDuration> searchAverageConnectionDuration(ExecutionContext executionContext, String apiId, Instant from, Instant to) {
        return this.analyticsRepository.searchAverageConnectionDuration(executionContext.getQueryContext(), new AverageConnectionDurationQuery(apiId, from, to)).map(averageAggregate -> AverageConnectionDuration.builder().globalAverage(Double.valueOf(averageAggregate.getAverage())).averagesByEntrypoint(averageAggregate.getAverageBy()).build());
    }

    @Override
    public Maybe<Map<String, Double>> searchAvgResponseTimeOverTime(ExecutionContext executionContext, List<String> apiIds, Instant startTime, Instant endTime, Duration interval, Collection<DefinitionVersion> versions) {
        return this.analyticsRepository.searchResponseTimeOverTime(executionContext.getQueryContext(), new ResponseTimeRangeQuery(apiIds, startTime, endTime, interval, versions)).map(AverageAggregate::getAverageBy);
    }

    @Override
    public ResponseStatusOvertime searchResponseStatusOvertime(ExecutionContext executionContext, AnalyticsQueryService.ResponseStatusOverTimeQuery query) {
        ResponseStatusOverTimeAggregate result = this.analyticsRepository.searchResponseStatusOvertime(executionContext.getQueryContext(), new ResponseStatusOverTimeQuery(query.apiIds(), query.from(), query.to(), query.interval(), query.versions()));
        return ResponseStatusOvertime.builder().data(result.getStatusCount()).timeRange(new ResponseStatusOvertime.TimeRange(query.from(), query.to(), query.interval())).build();
    }

    @Override
    public Optional<TopHitsApps> searchTopHitsApps(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        return this.analyticsRepository.searchTopApps(executionContext.getQueryContext(), new TopHitsQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo())).map(TopHitsAggregate::getTopHitsCounts).map(topHitCounts -> topHitCounts.entrySet().stream().map(entry -> TopHitsApps.TopHitApp.builder().id((String)entry.getKey()).count(((Long)entry.getValue()).longValue()).build()).toList()).map(topHitApp -> TopHitsApps.builder().data(topHitApp).build());
    }

    @Override
    public RequestResponseTime searchRequestResponseTime(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        RequestResponseTimeAggregate result = this.analyticsRepository.searchRequestResponseTimes(executionContext.getQueryContext(), new RequestResponseTimeQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo(), parameters.getDefinitionVersions()));
        return RequestResponseTime.builder().requestsPerSecond(Double.valueOf(result.getRequestsPerSecond())).requestsTotal(Long.valueOf(result.getRequestsTotal())).responseMinTime(Double.valueOf(result.getResponseMinTime())).responseMaxTime(Double.valueOf(result.getResponseMaxTime())).responseAvgTime(Double.valueOf(result.getResponseAvgTime())).build();
    }

    @Override
    public Optional<TopFailedApis> searchTopFailedApis(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        return this.analyticsRepository.searchTopFailedApis(executionContext.getQueryContext(), new TopFailedQueryCriteria(parameters.getApiIds(), parameters.getFrom(), parameters.getTo())).map(TopFailedAggregate::failedApis).map(topFailedApis -> topFailedApis.entrySet().stream().map(entry -> TopFailedApis.TopFailedApi.builder().id((String)entry.getKey()).failedCalls(((TopFailedAggregate.FailedApiInfo)entry.getValue()).failedCalls()).failedCallsRatio(((TopFailedAggregate.FailedApiInfo)entry.getValue()).failedCallsRatio()).build()).toList()).map(topFailedApi -> TopFailedApis.builder().data(topFailedApi).build());
    }
}

