/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.endpointgroup.AbstractEndpoint;
import io.gravitee.definition.model.v4.endpointgroup.AbstractEndpointGroup;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointGroupServices;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointServices;
import io.gravitee.definition.model.v4.nativeapi.NativeEndpointGroup;
import io.gravitee.definition.model.v4.service.Service;
import io.gravitee.rest.api.model.v4.connector.ConnectorPluginEntity;
import io.gravitee.rest.api.service.exceptions.EndpointConfigurationValidationException;
import io.gravitee.rest.api.service.exceptions.EndpointGroupNameAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.EndpointMissingException;
import io.gravitee.rest.api.service.exceptions.EndpointNameAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.EndpointNameInvalidException;
import io.gravitee.rest.api.service.exceptions.HealthcheckInheritanceException;
import io.gravitee.rest.api.service.exceptions.HealthcheckInvalidException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.ApiServicePluginService;
import io.gravitee.rest.api.service.v4.EndpointConnectorPluginService;
import io.gravitee.rest.api.service.v4.exception.EndpointGroupTypeInvalidException;
import io.gravitee.rest.api.service.v4.exception.EndpointGroupTypeMismatchInvalidException;
import io.gravitee.rest.api.service.v4.exception.EndpointTypeInvalidException;
import io.gravitee.rest.api.service.v4.validation.EndpointGroupsValidationService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EndpointGroupsValidationServiceImpl
extends TransactionalService
implements EndpointGroupsValidationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EndpointConnectorPluginService endpointService;
    private final ApiServicePluginService apiServicePluginService;

    public EndpointGroupsValidationServiceImpl(EndpointConnectorPluginService endpointService, ApiServicePluginService apiServicePluginService) {
        this.endpointService = endpointService;
        this.apiServicePluginService = apiServicePluginService;
    }

    @Override
    public List<EndpointGroup> validateAndSanitizeHttpV4(ApiType apiType, List<EndpointGroup> endpointGroups) {
        return this.validateAndSanitize(apiType, endpointGroups);
    }

    @Override
    public List<NativeEndpointGroup> validateAndSanitizeNativeV4(List<NativeEndpointGroup> endpointGroups) {
        return this.validateAndSanitize(ApiType.NATIVE, endpointGroups);
    }

    public <G extends AbstractEndpointGroup<? extends AbstractEndpoint>> List<G> validateAndSanitize(ApiType apiType, List<G> endpointGroups) {
        if (endpointGroups == null || endpointGroups.isEmpty()) {
            throw new EndpointMissingException();
        }
        HashSet names = new HashSet();
        endpointGroups.forEach(endpointGroup -> {
            this.validateUniqueEndpointGroupName(endpointGroup.getName(), names);
            ConnectorPluginEntity endpointConnector = (ConnectorPluginEntity)this.endpointService.findById(endpointGroup.getType());
            this.validateEndpointGroupType(apiType, endpointGroup.getType(), endpointConnector);
            this.validateEndpointsExistence((AbstractEndpointGroup)endpointGroup);
            this.validateServices(apiType, (AbstractEndpointGroup)endpointGroup);
            if (endpointGroup.getSharedConfiguration() != null) {
                endpointGroup.setSharedConfiguration(this.endpointService.validateSharedConfiguration(endpointConnector, endpointGroup.getSharedConfiguration()));
            }
            if (endpointGroup.getEndpoints() != null && !endpointGroups.isEmpty()) {
                endpointGroup.getEndpoints().forEach(endpoint -> {
                    this.validateUniqueEndpointName(endpoint.getName(), names);
                    this.validateEndpointWeight((AbstractEndpoint)endpoint);
                    this.validateEndpointType(endpoint.getType());
                    this.validateEndpointMatchType((AbstractEndpointGroup)endpointGroup, (AbstractEndpoint)endpoint);
                    this.validateEndpointConfiguration(endpointConnector, (AbstractEndpoint)endpoint);
                    this.validateSharedConfigurationInheritance((AbstractEndpointGroup)endpointGroup, (AbstractEndpoint)endpoint);
                    this.validateSharedConfigurationOverride(endpointConnector, (AbstractEndpoint)endpoint);
                    this.validateServices(apiType, (AbstractEndpointGroup)endpointGroup, (AbstractEndpoint)endpoint);
                });
            }
        });
        return endpointGroups;
    }

    private void validateEndpointWeight(AbstractEndpoint endpoint) {
        if (endpoint.getWeight() <= 0) {
            endpoint.setWeight(1);
        }
    }

    private void validateEndpointConfiguration(ConnectorPluginEntity endpointConnector, AbstractEndpoint endpoint) {
        endpoint.setConfiguration(this.endpointService.validateConnectorConfiguration(endpointConnector, endpoint.getConfiguration()));
    }

    private void validateSharedConfigurationOverride(ConnectorPluginEntity endpointConnector, AbstractEndpoint endpoint) {
        if (!endpoint.isInheritConfiguration()) {
            if (endpoint.getSharedConfigurationOverride() == null) {
                this.endpointService.validateSharedConfiguration(endpointConnector, "{}");
            } else {
                endpoint.setSharedConfigurationOverride(this.endpointService.validateSharedConfiguration(endpointConnector, endpoint.getSharedConfigurationOverride()));
            }
        }
    }

    private void validateSharedConfigurationInheritance(AbstractEndpointGroup endpointGroup, AbstractEndpoint endpoint) {
        if (endpoint.isInheritConfiguration() && endpointGroup.getSharedConfiguration() == null) {
            throw new EndpointConfigurationValidationException("Impossible to inherit from a null shared configuration for endpoint: " + endpoint.getName());
        }
    }

    private void validateEndpointsExistence(AbstractEndpointGroup endpointGroup) {
        if (endpointGroup instanceof EndpointGroup) {
            EndpointGroup asHttpEndpointGroup = (EndpointGroup)endpointGroup;
            this.validateHttpEndpointsExistence(asHttpEndpointGroup);
        } else if (endpointGroup instanceof NativeEndpointGroup) {
            NativeEndpointGroup asNativeEndpointGroup = (NativeEndpointGroup)endpointGroup;
            this.validateNativeEndpointsExistence(asNativeEndpointGroup);
        }
    }

    private void validateHttpEndpointsExistence(EndpointGroup endpointGroup) {
        Service endpointDiscoveryService;
        Service service = endpointDiscoveryService = endpointGroup.getServices() == null ? null : endpointGroup.getServices().getDiscovery();
        if (!(endpointDiscoveryService != null && endpointDiscoveryService.isEnabled() || endpointGroup.getEndpoints() != null && !endpointGroup.getEndpoints().isEmpty())) {
            throw new EndpointMissingException();
        }
    }

    private void validateNativeEndpointsExistence(NativeEndpointGroup endpointGroup) {
        if (endpointGroup.getEndpoints() == null || endpointGroup.getEndpoints().isEmpty()) {
            throw new EndpointMissingException();
        }
    }

    private void validateDiscovery(Service discovery) {
    }

    private void validateEndpointType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new EndpointTypeInvalidException(type);
        }
    }

    private void validateEndpointGroupType(ApiType apiType, String type, ConnectorPluginEntity connectorPluginEntity) {
        if (StringUtils.isBlank((CharSequence)type) || !connectorPluginEntity.getSupportedApiType().equals((Object)apiType)) {
            throw new EndpointGroupTypeInvalidException(type);
        }
    }

    private void validateEndpointMatchType(AbstractEndpointGroup endpointGroup, AbstractEndpoint endpoint) {
        if (!endpointGroup.getType().equals(endpoint.getType())) {
            throw new EndpointGroupTypeMismatchInvalidException(endpointGroup.getType());
        }
    }

    private void validateAndSetHealthCheckConfiguration(Service healthCheck) {
        if (StringUtils.isBlank((CharSequence)healthCheck.getType())) {
            this.logger.debug("HealthCheck requires a type");
            throw new HealthcheckInvalidException(healthCheck.getType());
        }
        healthCheck.setConfiguration(this.apiServicePluginService.validateApiServiceConfiguration(healthCheck.getType(), healthCheck.getConfiguration()));
    }

    private void validateName(String name) {
        if (name != null && name.contains(":")) {
            throw new EndpointNameInvalidException(name);
        }
    }

    private void validateUniqueEndpointGroupName(String name, Set<String> names) {
        this.validateName(name);
        if (names.contains(name)) {
            throw new EndpointGroupNameAlreadyExistsException(name);
        }
        names.add(name);
    }

    private void validateUniqueEndpointName(String name, Set<String> names) {
        this.validateName(name);
        if (names.contains(name)) {
            throw new EndpointNameAlreadyExistsException(name);
        }
        names.add(name);
    }

    private void validateServices(ApiType apiType, AbstractEndpointGroup endpointGroup) {
        if (!ApiType.NATIVE.equals((Object)apiType)) {
            this.validateHttpServices(((EndpointGroup)endpointGroup).getServices());
        }
    }

    private void validateServices(ApiType apiType, AbstractEndpointGroup endpointGroup, AbstractEndpoint endpoint) {
        if (!ApiType.NATIVE.equals((Object)apiType)) {
            this.validateHttpServices(((EndpointGroup)endpointGroup).getServices(), ((Endpoint)endpoint).getServices());
        }
    }

    private void validateHttpServices(EndpointGroupServices services) {
        if (services != null) {
            if (services.getDiscovery() != null) {
                this.validateDiscovery(services.getDiscovery());
            }
            if (services.getHealthCheck() != null) {
                this.validateAndSetHealthCheckConfiguration(services.getHealthCheck());
            }
        }
    }

    private void validateHttpServices(EndpointGroupServices groupServices, EndpointServices services) {
        if (services != null && services.getHealthCheck() != null) {
            boolean hcGroupWithoutConfig;
            Service serviceHealthCheck = services.getHealthCheck();
            if (serviceHealthCheck.isEnabled()) {
                this.validateAndSetHealthCheckConfiguration(serviceHealthCheck);
            }
            boolean bl = hcGroupWithoutConfig = groupServices == null || groupServices.getHealthCheck() == null || StringUtils.isBlank((CharSequence)groupServices.getHealthCheck().getConfiguration());
            if (!serviceHealthCheck.isOverrideConfiguration() && hcGroupWithoutConfig) {
                this.logger.debug("HealthCheck inherit from a missing configuration");
                throw new HealthcheckInheritanceException();
            }
            if (serviceHealthCheck.isOverrideConfiguration() && StringUtils.isBlank((CharSequence)serviceHealthCheck.getConfiguration())) {
                this.logger.debug("HealthCheck requires a configuration when overrideConfiguration is enabled");
                throw new HealthcheckInheritanceException();
            }
            if (groupServices != null && groupServices.getHealthCheck() != null && !serviceHealthCheck.getType().equals(groupServices.getHealthCheck().getType())) {
                this.logger.debug("HealthCheck with type [{}] inherit configuration from another HealthCheck type [{}]", (Object)serviceHealthCheck.getType(), (Object)groupServices.getHealthCheck().getType());
                throw new HealthcheckInheritanceException();
            }
        }
    }
}

