/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.List;
import lombok.Generated;

@UseCase
public class GetApiDefinitionUseCase {
    private final ApiCrudService apiCrudService;
    private final FlowCrudService flowCrudService;
    private final PlanQueryService planQueryService;

    public Output execute(Input input) {
        io.gravitee.apim.core.api.model.Api api = this.apiCrudService.get(input.apiId);
        switch (api.getDefinitionVersion()) {
            case V1: 
            case V2: {
                api.getApiDefinition().setFlows(this.flowCrudService.getApiV2Flows(api.getId()));
                break;
            }
            case V4: {
                if (api.getType() == ApiType.NATIVE) {
                    api.getApiDefinitionNativeV4().setFlows(this.flowCrudService.getNativeApiFlows(api.getId()));
                    break;
                }
                api.getApiDefinitionHttpV4().setFlows(this.flowCrudService.getApiV4Flows(api.getId()));
            }
        }
        List<Plan> plans = this.planQueryService.findAllByApiId(api.getId()).stream().filter(plan -> plan.getPlanStatus() == PlanStatus.PUBLISHED || plan.getPlanStatus() == PlanStatus.DEPRECATED).peek(plan -> {
            switch (plan.getDefinitionVersion()) {
                case V1: 
                case V2: {
                    plan.getPlanDefinitionV2().setFlows(this.flowCrudService.getPlanV2Flows(plan.getId()));
                    break;
                }
                case V4: {
                    if (api.getType() == ApiType.NATIVE) {
                        plan.getPlanDefinitionNativeV4().setFlows(this.flowCrudService.getNativePlanFlows(plan.getId()));
                        break;
                    }
                    plan.getPlanDefinitionHttpV4().setFlows(this.flowCrudService.getPlanV4Flows(plan.getId()));
                }
            }
        }).toList();
        api.setPlans(plans);
        return new Output(api.getDefinitionVersion(), api.getApiDefinitionHttpV4(), api.getApiDefinitionNativeV4(), api.getApiDefinition());
    }

    @Generated
    public GetApiDefinitionUseCase(ApiCrudService apiCrudService, FlowCrudService flowCrudService, PlanQueryService planQueryService) {
        this.apiCrudService = apiCrudService;
        this.flowCrudService = flowCrudService;
        this.planQueryService = planQueryService;
    }

    public record Input(String apiId) {
    }

    public record Output(DefinitionVersion definitionVersion, Api apiDefinitionHttpV4, NativeApi apiDefinitionNativeV4, io.gravitee.definition.model.Api apiDefinition) {
    }
}

