/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.Subscription;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ClientIdInApiKeySubscriptionsUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientIdInApiKeySubscriptionsUpgrader.class);
    private final SubscriptionRepository subscriptionRepository;

    @Autowired
    public ClientIdInApiKeySubscriptionsUpgrader(@Lazy SubscriptionRepository subscriptionRepository) {
        this.subscriptionRepository = subscriptionRepository;
    }

    public int getOrder() {
        return 502;
    }

    public boolean upgrade() {
        try {
            SubscriptionCriteria.SubscriptionCriteriaBuilder criteriaBuilder = SubscriptionCriteria.builder();
            criteriaBuilder.planSecurityTypes(List.of(Plan.PlanSecurityType.API_KEY.name()));
            this.subscriptionRepository.search(criteriaBuilder.build()).forEach(this::updateApiKeySubscriptions);
        }
        catch (Exception e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
        return true;
    }

    private void updateApiKeySubscriptions(Subscription subscription) {
        try {
            if (subscription.getClientId() != null) {
                log.debug("Removing clientId from API Key subscription [{}]", (Object)subscription);
                subscription.setClientId(null);
                this.subscriptionRepository.update((Object)subscription);
            }
        }
        catch (TechnicalException e) {
            log.error("Failed to remove clientID from API Key subscriptions for API Key [{}]", (Object)subscription, (Object)e);
        }
    }
}

