/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.metadata;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.metadata.crud_service.MetadataCrudService;
import io.gravitee.apim.core.metadata.model.MetadataId;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.infra.adapter.MetadataAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataReferenceType;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MetadataCrudServiceImpl
implements MetadataCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataCrudServiceImpl.class);
    private final MetadataRepository metadataRepository;

    public MetadataCrudServiceImpl(@Lazy MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }

    @Override
    public io.gravitee.apim.core.metadata.model.Metadata create(io.gravitee.apim.core.metadata.model.Metadata metadata) {
        try {
            Metadata result = this.metadataRepository.create(MetadataAdapter.INSTANCE.toRepository(metadata));
            return MetadataAdapter.INSTANCE.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to create the %s metadata of [%sId=%s]", metadata.getKey(), metadata.getReferenceType().name().toLowerCase(), metadata.getReferenceId()), e);
        }
    }

    @Override
    public Optional<io.gravitee.apim.core.metadata.model.Metadata> findById(MetadataId id) {
        try {
            return this.metadataRepository.findById(id.getKey(), id.getReferenceId(), MetadataReferenceType.valueOf((String)id.getReferenceType().name())).map(MetadataAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while finding metadata by id [%s, %s, %s]", id.getReferenceId(), id.getReferenceType().name(), id.getKey()), e);
        }
    }

    @Override
    public Collection<io.gravitee.apim.core.metadata.model.Metadata> findByApiId(String id) {
        try {
            return CollectionUtils.stream(this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.API, id)).map(MetadataAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurred while finding metadata by API id [%s]".formatted(id), e);
        }
    }

    @Override
    public Collection<io.gravitee.apim.core.metadata.model.Metadata> findByEnvId(String id) {
        try {
            return CollectionUtils.stream(this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.ENVIRONMENT, id)).map(MetadataAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurred while finding metadata by API id [%s]".formatted(id), e);
        }
    }

    @Override
    public io.gravitee.apim.core.metadata.model.Metadata update(io.gravitee.apim.core.metadata.model.Metadata metadata) {
        try {
            Metadata result = this.metadataRepository.update(MetadataAdapter.INSTANCE.toRepository(metadata));
            return MetadataAdapter.INSTANCE.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to update the %s metadata of [%sId=%s]", metadata.getKey(), metadata.getReferenceType().name().toLowerCase(), metadata.getReferenceId()), e);
        }
    }

    @Override
    public void delete(MetadataId id) {
        try {
            this.metadataRepository.delete(id.getKey(), id.getReferenceId(), MetadataReferenceType.valueOf((String)id.getReferenceType().name()));
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to delete the metadata with key: %s", id.getKey()), e);
        }
    }
}

