/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.domain_service.RejectSubscriptionDomainService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import lombok.Generated;

@UseCase
public class RejectSubscriptionUseCase {
    private final SubscriptionCrudService subscriptionCrudService;
    private final PlanCrudService planCrudService;
    private final RejectSubscriptionDomainService rejectSubscriptionDomainService;

    public RejectSubscriptionUseCase(SubscriptionCrudService subscriptionCrudService, PlanCrudService planCrudService, RejectSubscriptionDomainService rejectSubscriptionDomainService) {
        this.subscriptionCrudService = subscriptionCrudService;
        this.planCrudService = planCrudService;
        this.rejectSubscriptionDomainService = rejectSubscriptionDomainService;
    }

    public Output execute(Input input) {
        SubscriptionEntity subscription = this.subscriptionCrudService.get(input.subscriptionId);
        if (!input.apiId.equalsIgnoreCase(subscription.getApiId())) {
            throw new SubscriptionNotFoundException(input.subscriptionId);
        }
        this.checkSubscriptionStatus(subscription);
        this.checkPlanStatus(subscription);
        return new Output(this.rejectSubscriptionDomainService.reject(subscription, input.reasonMessage, input.auditInfo));
    }

    private void checkSubscriptionStatus(SubscriptionEntity subscriptionEntity) {
        if (!subscriptionEntity.isPending()) {
            throw new IllegalStateException("Cannot reject subscription");
        }
    }

    private void checkPlanStatus(SubscriptionEntity subscription) {
        Plan plan = this.planCrudService.getById(subscription.getPlanId());
        if (plan.isClosed()) {
            throw new PlanAlreadyClosedException(plan.getId());
        }
    }

    public record Input(String apiId, String subscriptionId, String reasonMessage, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String apiId;
            @Generated
            private String subscriptionId;
            @Generated
            private String reasonMessage;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder subscriptionId(String subscriptionId) {
                this.subscriptionId = subscriptionId;
                return this;
            }

            @Generated
            public InputBuilder reasonMessage(String reasonMessage) {
                this.reasonMessage = reasonMessage;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiId, this.subscriptionId, this.reasonMessage, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "RejectSubscriptionUseCase.Input.InputBuilder(apiId=" + this.apiId + ", subscriptionId=" + this.subscriptionId + ", reasonMessage=" + this.reasonMessage + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(SubscriptionEntity subscription) {
    }
}

